/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.mainorder;

import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLogger;
import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLoggerFactory;
import cn.com.duiba.order.center.api.dto.OrderSyncMessageDto;
import cn.com.duiba.order.center.api.dto.TuiAOrderSyncMessage;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderSyncService {
    private static DuiBaLogger log = DuiBaLoggerFactory.getLogger(OrderSyncService.class);
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;

    public void sync(Long orderId, Long consumerId) {
        try {
            OrderSyncMessageDto msg = new OrderSyncMessageDto();
            msg.setOrderId(orderId);
            msg.setConsumerId(consumerId);
            String body = JSONObject.toJSONString((Object)msg);
            this.messageService.sendMsg(this.topicConstant.getTopicOrdersDataSync(), body);
        }
        catch (Exception e) {
            log.error("order sync error:[orderId:" + orderId + " consumerId:" + consumerId + "]", (Throwable)e);
        }
    }

    public void sendMsgToTuia(OrdersEntity order) {
        try {
            TuiAOrderSyncMessage msg = new TuiAOrderSyncMessage();
            msg.setOrderId(order.getId());
            msg.setConsumerId(order.getConsumerId());
            msg.setAppId(order.getAppId());
            msg.setItemId(order.getItemId());
            msg.setOperatingActivityId(order.getRelationId());
            msg.setGmtCreate(order.getGmtCreate());
            String body = JSONObject.toJSONString((Object)msg);
            this.messageService.sendMsg(this.topicConstant.getCouponToTuia(), body);
        }
        catch (Exception e) {
            log.error("tuia sync error:[orderId:" + order.getId() + " consumerId:" + order.getConsumerId() + "]", (Throwable)e);
        }
    }
}

