/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.tool;

import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLogger;
import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLoggerFactory;
import cn.com.duiba.order.center.biz.tool.TradeCenterException;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KafkaClient
implements InitializingBean {
    private static DuiBaLogger log = DuiBaLoggerFactory.getLogger(KafkaClient.class);
    private Producer<String, String> producer = null;
    @Value(value="${trade.kafka.bootstrap.servers}")
    private String bootstrapServers;

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public Producer<String, String> getProducer() {
        return this.producer;
    }

    public String sendMsg(String queueName, String body) {
        String id = UUID.randomUUID().toString().replaceAll("-", "");
        this.producer.send(new ProducerRecord(queueName, (Object)id, (Object)body), new Callback(){

            public void onCompletion(RecordMetadata recordMetadata, Exception e) {
                if (e != null) {
                    log.error("producer.send", (Throwable)e);
                }
            }
        });
        return id;
    }

    public String sendMsgSync(String queueName, String body) {
        String id = UUID.randomUUID().toString().replaceAll("-", "");
        Future future = this.producer.send(new ProducerRecord(queueName, (Object)id, (Object)body), new Callback(){

            public void onCompletion(RecordMetadata recordMetadata, Exception e) {
                if (e != null) {
                    log.error("producer.send", (Throwable)e);
                }
            }
        });
        try {
            future.get();
        }
        catch (Exception e) {
            log.error("onCompletion is exception", (Throwable)e);
            throw new TradeCenterException("sendMsgSync error");
        }
        return id;
    }

    public void afterPropertiesSet() throws Exception {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("acks", "all");
        props.put("retries", (Object)3);
        props.put("batch.size", (Object)16384);
        props.put("linger.ms", (Object)0);
        props.put("request.timeout.ms", (Object)30000);
        props.put("metadata.fetch.timeout.ms", (Object)10000);
        props.put("buffer.memory", (Object)0x2000000);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producer = new KafkaProducer(props);
    }
}

