/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.tool;

import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLogger;
import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;

public class TimeProfile {
    private static DuiBaLogger log = DuiBaLoggerFactory.getLogger(TimeProfile.class);
    private static ThreadLocal<Stack<TimeProfileStack>> stack = new ThreadLocal();
    private static ThreadLocal<List<TimeProfileStack>> logs = new ThreadLocal();
    static ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    static int threshold = 1;

    public static void enter() {
        TimeProfile.enter("");
    }

    public static void enter(String tag) {
        if (stack.get() == null) {
            return;
        }
        TimeProfileStack t = new TimeProfileStack();
        t.setEnterTime(new Date());
        t.setTag(tag);
        t.setDeep(stack.get().size());
        t.index = logs.get().size() + stack.get().size();
        stack.get().push(t);
    }

    public static void release() {
        if (stack.get() == null) {
            return;
        }
        TimeProfileStack t = stack.get().pop();
        t.setReleaseTime(new Date());
        logs.get().add(t);
    }

    public static void start() {
        stack.set(new Stack());
        logs.set(new ArrayList());
        TimeProfile.enter();
    }

    public static void end() {
        TimeProfileStack t = stack.get().pop();
        t.setReleaseTime(new Date());
        logs.get().add(t);
        Long timeconsume = t.getReleaseTime().getTime() - t.getEnterTime().getTime();
        if (timeconsume > (long)threshold) {
            StringBuilder sb = new StringBuilder();
            sb.append("TimeProfile timeout " + timeconsume + "ms ");
            ArrayList list = new ArrayList(logs.get());
            Collections.sort(list, new Comparator<TimeProfileStack>(){

                @Override
                public int compare(TimeProfileStack o1, TimeProfileStack o2) {
                    if (o1.index > o2.index) {
                        return 1;
                    }
                    if (o1.index < o2.index) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (TimeProfileStack s : list) {
                sb.append("\r\n\t");
                for (int i = 0; i < s.getDeep(); ++i) {
                    sb.append("-");
                }
                Long consume = s.getReleaseTime().getTime() - s.getEnterTime().getTime();
                sb.append(consume * 100L / timeconsume + "%");
                sb.append("  " + consume + "ms");
                if (s.getTag() != null) {
                    sb.append("  " + s.getTag());
                }
                if (s.getStackTraceElement() == null) continue;
                StackTraceElement ste = s.getStackTraceElement();
                sb.append("  " + ste.getClassName() + "." + ste.getMethodName() + " line:" + ste.getLineNumber());
            }
            log.error(sb.toString());
        }
        request.set(null);
        stack.set(null);
        logs.set(null);
    }

    public static String dump(long ms) {
        if (logs.get() == null) {
            return null;
        }
        TimeProfileStack t = stack.get().pop();
        t.setReleaseTime(new Date());
        logs.get().add(t);
        Long timeconsume = 0L;
        for (TimeProfileStack s : logs.get()) {
            if (s.deep != 0) continue;
            timeconsume = timeconsume + (s.getReleaseTime().getTime() - s.getEnterTime().getTime());
        }
        if (timeconsume < ms) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("TimeProfile timeout " + timeconsume + "ms ");
        ArrayList list = new ArrayList(logs.get());
        Collections.sort(list, new Comparator<TimeProfileStack>(){

            @Override
            public int compare(TimeProfileStack o1, TimeProfileStack o2) {
                if (o1.index > o2.index) {
                    return 1;
                }
                if (o1.index < o2.index) {
                    return -1;
                }
                return 0;
            }
        });
        for (TimeProfileStack s : list) {
            Long consume = s.getReleaseTime().getTime() - s.getEnterTime().getTime();
            if (consume == 0L) continue;
            sb.append("\r\n\t");
            for (int i = 0; i < s.getDeep(); ++i) {
                sb.append("  ");
            }
            sb.append("-");
            sb.append(consume * 100L / timeconsume + "%");
            sb.append("  " + consume + "ms");
            if (s.getTag() != null) {
                sb.append("  " + s.getTag());
            }
            if (s.getStackTraceElement() == null) continue;
            StackTraceElement ste = s.getStackTraceElement();
            sb.append("  " + ste.getClassName() + "." + ste.getMethodName() + " line:" + ste.getLineNumber());
        }
        request.set(null);
        stack.set(null);
        logs.set(null);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        TimeProfile.start();
        try {
            Thread.sleep(1000L);
            TimeProfile.enter("in");
            Thread.sleep(1000L);
            TimeProfile.release();
        }
        finally {
            TimeProfile.release();
        }
        System.err.println(TimeProfile.dump(0L));
    }

    public static class TimeProfileStack {
        private Date enterTime;
        private Date releaseTime;
        private int deep;
        private String tag;
        int index;
        private StackTraceElement stackTraceElement;

        public Date getEnterTime() {
            return this.enterTime;
        }

        public void setEnterTime(Date enterTime) {
            this.enterTime = enterTime;
        }

        public Date getReleaseTime() {
            return this.releaseTime;
        }

        public void setReleaseTime(Date releaseTime) {
            this.releaseTime = releaseTime;
        }

        public int getDeep() {
            return this.deep;
        }

        public void setDeep(int deep) {
            this.deep = deep;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public StackTraceElement getStackTraceElement() {
            return this.stackTraceElement;
        }

        public void setStackTraceElement(StackTraceElement stackTraceElement) {
            this.stackTraceElement = stackTraceElement;
        }
    }
}

