/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.handle;

import cn.com.duiba.idmaker.service.api.enums.IDMakerTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.order.center.biz.dao.BaseActivityOrderDaoTool;
import cn.com.duiba.order.center.biz.dao.activity.ActivityOrderDao;
import cn.com.duiba.order.center.biz.dao.activityhouse.ActivityOrderHouseDao;
import cn.com.duiba.order.center.biz.entity.ActivityOrderEntity;
import cn.com.duiba.order.center.biz.tool.TradeCenterException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityOrderHandle {
    @Resource
    private RemoteIDMakerService remoteIDMakerService;
    @Autowired
    private ActivityOrderDao activityOrderDao;
    @Autowired
    private ActivityOrderHouseDao activityOrderHouseDao;

    public void insert(ActivityOrderEntity entity) {
        DubboResult ret = this.remoteIDMakerService.getNextID(IDMakerTypeEnums.ACTIVITY_ORDER.getType());
        if (!ret.isSuccess()) {
            throw new TradeCenterException("ID\u751f\u6210\u5931\u8d25");
        }
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(entity.getConsumerId());
        String orderNum = ret.getResult() + suffix;
        entity.setSuffix(suffix);
        entity.setOrderNum(orderNum);
        this.activityOrderDao.insert(entity);
    }

    public ActivityOrderEntity find(String orderNum) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        return this.activityOrderDao.find(suffix, orderNum);
    }

    public int updateCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        return this.activityOrderDao.updateCreditsSuccess(suffix, orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, 2);
    }

    public int updateCreditsSuccessDowngrade(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        return this.activityOrderDao.updateCreditsSuccessDowngrade(suffix, orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, 2);
    }

    public int updateCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        error4admin = StringUtils.substring((String)error4admin, (int)0, (int)200);
        error4developer = StringUtils.substring((String)error4developer, (int)0, (int)200);
        error4consumer = StringUtils.substring((String)error4consumer, (int)0, (int)200);
        return this.activityOrderDao.updateCreditsFail(suffix, orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer, 3);
    }

    public int updateAddCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        return this.activityOrderDao.updateAddCreditsSuccess(suffix, orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, 2);
    }

    public int updateAddCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        error4admin = StringUtils.substring((String)error4admin, (int)0, (int)200);
        error4developer = StringUtils.substring((String)error4developer, (int)0, (int)200);
        error4consumer = StringUtils.substring((String)error4consumer, (int)0, (int)200);
        return this.activityOrderDao.updateAddCreditsFail(suffix, orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer, 3);
    }

    public int addCreditsStatusToProcessing(String orderNum) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        return this.activityOrderDao.addCreditsStatusToProcessing(suffix, orderNum, 1);
    }

    public int updateExchangeStatusWait(String orderNum) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        return this.activityOrderDao.updateExchangeStatus(suffix, orderNum, 1);
    }

    public int updateExchangeStatusSuccess(String orderNum) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        return this.activityOrderDao.updateExchangeStatus(suffix, orderNum, 2);
    }

    public int updateExchangeStatusFail(String orderNum) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        return this.activityOrderDao.updateExchangeStatus(suffix, orderNum, 3);
    }

    public int updateExchangeStatusOverdue(String orderNum) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        return this.activityOrderDao.updateExchangeStatus(suffix, orderNum, 4);
    }

    public int updateDeveloperBizId(String orderNum, String bizId) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        return this.activityOrderDao.updateDeveloperBizId(suffix, orderNum, bizId);
    }

    public int updateAddDeveloperBizId(String orderNum, String bizId) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        return this.activityOrderDao.updateAddDeveloperBizId(suffix, orderNum, bizId);
    }

    public int updateMainOrderNum(String orderNum, String mainOrderNum) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        return this.activityOrderDao.updateMainOrderNum(suffix, orderNum, mainOrderNum);
    }

    public int countConsumerJoinNum(long consumerId, long duibaActivityId, String activityType) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        return this.activityOrderDao.countConsumerJoinNum(suffix, consumerId, duibaActivityId, activityType);
    }

    public List<ActivityOrderEntity> findConsumerJoinList(long consumerId, List<Long> duibaActivityIds, String activityType) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        return this.activityOrderDao.findConsumerJoinList(suffix, consumerId, duibaActivityIds, activityType);
    }

    public ActivityOrderEntity findConsumerDuibaActivity4day(long consumerId, Long duibaActivityId, String activityType, String start, String end) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        return this.activityOrderDao.findConsumerDuibaActivity4day(suffix, consumerId, duibaActivityId, activityType, start, end);
    }

    public List<ActivityOrderEntity> findByOrderNums(long consumerId, List<String> orderNums) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        return this.activityOrderDao.findByOrderNums(suffix, orderNums);
    }

    public List<Long> findOptionIds(Long consumerId, Long appId, String activityType) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        return this.activityOrderDao.findOptionIds(consumerId, appId, activityType, suffix);
    }

    public int updateAddCredits(String orderNum, Long credits) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
        return this.activityOrderDao.updateAddCredits(suffix, orderNum, credits);
    }

    public List<String> findByExpirationTime(String expirationTime, String activityType) {
        return this.activityOrderHouseDao.findByExpirationTime(expirationTime, activityType);
    }

    public List<Long> findOptionIdsHouse(Long consumerId, Long appId, String activityType) {
        return this.activityOrderHouseDao.findOptionIds(consumerId, appId, activityType);
    }

    public List<ActivityOrderEntity> findByAppIdWithPage(Map<String, Object> queryMap) {
        return this.activityOrderHouseDao.findByAppIdWithPage(queryMap);
    }

    public int getCountByAppId(Map<String, Object> queryMap) {
        return this.activityOrderHouseDao.getCountByAppId(queryMap);
    }

    public List<Map<String, Long>> findFailByActivity4App(List<Long> activityIds, Long appId) {
        return this.activityOrderHouseDao.findFailByActivity4App(activityIds, appId);
    }
}

