/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.bo;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.SupplierOrderDto;
import cn.com.duiba.order.center.biz.service.credits.AmbOrderFastService;
import cn.com.duiba.order.center.biz.service.credits.AmbSubOrdersService;
import cn.com.duiba.order.center.biz.service.credits.SupplierOrdersService;
import cn.com.duiba.order.center.biz.service.mainorder.OrderSyncService;
import cn.com.duiba.order.center.biz.service.mainorder.orderconsumer.OrderSimpleService;
import cn.com.duiba.order.center.biz.service.mainorder.orderconsumer.OrdersStatusChangeService;
import cn.com.duiba.service.exception.BusinessException;
import com.google.common.base.Objects;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class TransactionBo {
    @Autowired
    private OrdersStatusChangeService ordersStatusChangeService;
    @Autowired
    private OrderSimpleService ordersSimpleService;
    @Resource
    private PlatformTransactionManager ordersConsumerTransactionManager;
    @Autowired
    private SupplierOrdersService supplierOrdersService;
    @Autowired
    private OrderSyncService orderSyncService;
    @Autowired
    private AmbSubOrdersService ambSubOrdersService;
    @Autowired
    private AmbOrderFastService ambOrderFastService;
    public static final String ERROR_STRING_INVALID_STATUS = "\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c";

    public void createPayBackRecordAtMakeFail(OrdersDto orders) throws BusinessException {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            this.ambSubOrdersService.updateSettleStatusNoneBySubId(orders.getSubOrderId(), orders.getConsumerPayPrice());
            this.ambOrderFastService.deleteByOrderId(orders.getId());
        }
        catch (Exception e) {
            status.setRollbackOnly();
            throw e;
        }
        finally {
            this.ordersConsumerTransactionManager.commit(status);
        }
    }

    public boolean doMakeConsumeSuccess(Long orderId, Long consumerId) throws BusinessException {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
            if (!"create".equals(order.getStatus())) {
                status.setRollbackOnly();
                throw new BusinessException(ERROR_STRING_INVALID_STATUS);
            }
            int ret = this.ordersStatusChangeService.doMakeConsumeSuccess(order.getId(), consumerId);
            if (ret == 0) {
                status.setRollbackOnly();
                throw new BusinessException(ERROR_STRING_INVALID_STATUS);
            }
        }
        catch (BusinessException e) {
            status.setRollbackOnly();
            throw e;
        }
        finally {
            this.ordersConsumerTransactionManager.commit(status);
            this.orderSyncService.sync(orderId, consumerId);
        }
        return true;
    }

    public boolean doMakeConsumeFail(Long orderId, Long consumerId, Integer failType, String error4consumer, String error4developer, String error4admin) throws BusinessException {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
            if (!"create".equals(order.getStatus())) {
                status.setRollbackOnly();
                throw new BusinessException(ERROR_STRING_INVALID_STATUS);
            }
            String subError4consumer = StringUtils.substring((String)error4consumer, (int)0, (int)200);
            String subError4developer = StringUtils.substring((String)error4developer, (int)0, (int)200);
            String subError4admin = StringUtils.substring((String)error4admin, (int)0, (int)200);
            int ret = this.ordersStatusChangeService.doMakeConsumeFail(order.getId(), consumerId, failType, subError4consumer, subError4developer, subError4admin);
            if (ret == 0) {
                status.setRollbackOnly();
                throw new BusinessException(ERROR_STRING_INVALID_STATUS);
            }
        }
        catch (BusinessException e) {
            status.setRollbackOnly();
            throw e;
        }
        finally {
            this.ordersConsumerTransactionManager.commit(status);
            this.orderSyncService.sync(orderId, consumerId);
        }
        return true;
    }

    public boolean doAmbPaySuccess(Long orderId, Long consumerId) throws BusinessException {
        block7: {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
            try {
                OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
                if ("consume_success".equals(order.getStatus()) && "wait_pay".equals(order.getConsumerPayStatus())) {
                    int ret = this.ordersStatusChangeService.doAmbConsumerPayStatusPaySuccess(orderId, consumerId);
                    if (ret == 0) {
                        throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                    }
                    break block7;
                }
                throw new BusinessException("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c");
            }
            catch (BusinessException e1) {
                status.setRollbackOnly();
                throw e1;
            }
            finally {
                this.ordersConsumerTransactionManager.commit(status);
                this.orderSyncService.sync(orderId, consumerId);
            }
        }
        return true;
    }

    public boolean doAuditReject(Long orderId, Long consumerId) throws BusinessException {
        block8: {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
            try {
                OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
                if (order.getConsumerPayPrice() > 0L && !"pay_success".equals(order.getConsumerPayStatus())) {
                    throw new BusinessException("\u52a0\u94b1\u8d2d\u4ed8\u8d39\u72b6\u6001\u5f02\u5e38");
                }
                if ("wait".equals(order.getAuditStatus()) && "consume_success".equals(order.getStatus())) {
                    order.setAuditStatus("reject");
                    order.setAuditTime(new Date());
                    String errorInfo = "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                    order.setError4Consumer(errorInfo);
                    order.setError4Developer(errorInfo);
                    order.setError4Admin(errorInfo);
                    order.setFailType(Integer.valueOf(4));
                    int ret = this.ordersStatusChangeService.doAuditReject(order.getId(), order.getConsumerId(), order.getError4Consumer(), order.getError4Developer(), order.getError4Admin(), order.getFailType());
                    if (ret == 0) {
                        status.setRollbackOnly();
                        throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                    }
                    break block8;
                }
                status.setRollbackOnly();
                throw new BusinessException("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c");
            }
            catch (BusinessException e1) {
                status.setRollbackOnly();
                throw e1;
            }
            finally {
                this.ordersConsumerTransactionManager.commit(status);
                this.orderSyncService.sync(orderId, consumerId);
            }
        }
        return true;
    }

    public boolean doMakeSuccess(Long orderId, Long consumerId) throws BusinessException {
        block13: {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
            if (!status.isNewTransaction()) {
                throw new BusinessException("doMakeSuccess \u4e0d\u80fd\u5d4c\u5957\u4e8b\u52a1");
            }
            try {
                OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
                if (!"success".equals(order.getStatus()) && !"fail".equals(order.getStatus())) {
                    int ret;
                    if (order.getSupplierOrderId() != null) {
                        SupplierOrderDto so4u = new SupplierOrderDto(order.getSupplierOrderId());
                        so4u.setStatus("success");
                        this.supplierOrdersService.update(so4u);
                    }
                    String duibaPayStatus = null;
                    if (!Objects.equal((Object)"none", (Object)order.getDuibaPayStatus())) {
                        duibaPayStatus = "success";
                    }
                    String payStatus = null;
                    if (!Objects.equal((Object)"none", (Object)order.getPayStatus())) {
                        payStatus = "successs";
                    }
                    String consumerPayStatus = null;
                    if (order.getConsumerPayPrice() > 0L && "pay_success".equals(order.getConsumerPayStatus())) {
                        consumerPayStatus = "success";
                    }
                    if ((ret = this.ordersStatusChangeService.doMakeSuccess(orderId, consumerId, payStatus, duibaPayStatus, consumerPayStatus).intValue()) == 0) {
                        status.setRollbackOnly();
                        throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                    }
                    if (this.isSendToTuia(order)) {
                        this.orderSyncService.sendMsgToTuia(order);
                    }
                    break block13;
                }
                status.setRollbackOnly();
                throw new BusinessException("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8fdb\u884c\u6210\u529f\u64cd\u4f5c");
            }
            catch (BusinessException e1) {
                status.setRollbackOnly();
                throw e1;
            }
            finally {
                this.ordersConsumerTransactionManager.commit(status);
                this.orderSyncService.sync(orderId, consumerId);
            }
        }
        return true;
    }

    private boolean isSendToTuia(OrdersDto order) {
        if (order == null) {
            return false;
        }
        return "coupon".equals(order.getType());
    }

    public boolean doMakeFail(Long orderId, Long consumerId) throws BusinessException {
        block29: {
            OrdersDto tempOrder = this.ordersSimpleService.findById(orderId, consumerId);
            if (tempOrder.getActualPrice() > 0 || tempOrder.getDuibaActualPrice() > 0) {
                DefaultTransactionDefinition def = new DefaultTransactionDefinition();
                TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
                if (!status.isNewTransaction()) {
                    throw new BusinessException("doMakeFail \u4e0d\u80fd\u5d4c\u5957\u4e8b\u52a1");
                }
                try {
                    int ret;
                    OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
                    if ("success".equals(order.getStatus()) || "fail".equals(order.getStatus())) {
                        throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                    }
                    if ("successs".equals(order.getPayStatus()) || "payback".equals(order.getPayStatus())) {
                        throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                    }
                    if ("payback".equals(order.getDuibaPayStatus()) || "success".equals(order.getDuibaPayStatus())) {
                        throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                    }
                    String duibaPayStatus = null;
                    if (!Objects.equal((Object)"none", (Object)order.getDuibaPayStatus())) {
                        duibaPayStatus = order.getDuibaPayStatus();
                    }
                    String payStatus = null;
                    if (!Objects.equal((Object)"none", (Object)order.getPayStatus())) {
                        payStatus = order.getPayStatus();
                    }
                    String consumerPayStatus = null;
                    Long consumerPaybackPrice = null;
                    if (order.getConsumerPayPrice() > 0L) {
                        if ("wait_pay".equals(order.getConsumerPayStatus())) {
                            consumerPayStatus = "canceled";
                        } else if ("pay_success".equals(order.getConsumerPayStatus())) {
                            consumerPayStatus = "pay_back";
                            consumerPaybackPrice = order.getConsumerPayPrice();
                        }
                    }
                    if ((ret = this.ordersStatusChangeService.doMakeFail(orderId, consumerId, payStatus, duibaPayStatus, consumerPayStatus, consumerPaybackPrice).intValue()) == 0) {
                        status.setRollbackOnly();
                        throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                    }
                }
                catch (BusinessException e) {
                    status.setRollbackOnly();
                    throw e;
                }
                finally {
                    this.ordersConsumerTransactionManager.commit(status);
                    this.orderSyncService.sync(orderId, consumerId);
                }
                return true;
            }
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
            try {
                OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
                if (!"success".equals(order.getStatus()) && !"fail".equals(order.getStatus())) {
                    int ret;
                    String consumerPayStatus = null;
                    Long consumerPaybackPrice = null;
                    if (order.getConsumerPayPrice() > 0L) {
                        if ("wait_pay".equals(order.getConsumerPayStatus())) {
                            consumerPayStatus = "canceled";
                        } else if ("pay_success".equals(order.getConsumerPayStatus())) {
                            consumerPayStatus = "pay_back";
                            consumerPaybackPrice = order.getConsumerPayPrice();
                        }
                    }
                    if ((ret = this.ordersStatusChangeService.doMakeFail(orderId, consumerId, null, null, consumerPayStatus, consumerPaybackPrice).intValue()) == 0) {
                        status.setRollbackOnly();
                        throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                    }
                    break block29;
                }
                status.setRollbackOnly();
                throw new BusinessException("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6267\u884c\u5931\u8d25\u64cd\u4f5c");
            }
            catch (BusinessException e) {
                status.setRollbackOnly();
                throw e;
            }
            finally {
                this.ordersConsumerTransactionManager.commit(status);
                this.orderSyncService.sync(orderId, consumerId);
            }
        }
        return true;
    }

    public boolean doUpdateAllowInputUsed(Long orderId, Long consumerId, SupplierOrderDto supplierOrder, String bizParams, String brief) throws BusinessException {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
            if ("success".equals(order.getStatus()) || "fail".equals(order.getStatus()) || !order.getAllowInputAgain().booleanValue()) {
                throw new BusinessException(ERROR_STRING_INVALID_STATUS);
            }
            this.supplierOrdersService.insert(supplierOrder);
            int ret = this.ordersStatusChangeService.doUpdateAllowInputUsed(order.getId(), consumerId, supplierOrder.getId(), bizParams, brief);
            if (ret == 0) {
                throw new BusinessException(ERROR_STRING_INVALID_STATUS);
            }
        }
        catch (BusinessException e1) {
            status.setRollbackOnly();
            throw e1;
        }
        finally {
            this.ordersConsumerTransactionManager.commit(status);
            this.orderSyncService.sync(orderId, consumerId);
        }
        return true;
    }

    public boolean doUpdateAllowInputUsed4Object(Long orderId, Long consumerId, SupplierOrderDto supplierOrder, String bizParams) throws BusinessException {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
            if ("success".equals(order.getStatus()) || "fail".equals(order.getStatus()) || !order.getAllowInputAgain().booleanValue()) {
                throw new BusinessException(ERROR_STRING_INVALID_STATUS);
            }
            this.supplierOrdersService.insert(supplierOrder);
            int ret = this.ordersStatusChangeService.doUpdateAllowInputUsed4Object(order.getId(), consumerId, supplierOrder.getId(), bizParams);
            if (ret == 0) {
                throw new BusinessException(ERROR_STRING_INVALID_STATUS);
            }
        }
        catch (BusinessException e1) {
            status.setRollbackOnly();
            throw e1;
        }
        finally {
            this.ordersConsumerTransactionManager.commit(status);
            this.orderSyncService.sync(orderId, consumerId);
        }
        return true;
    }

    public boolean doAmbStatusAfterSend(Long orderId, Long consumerId) throws BusinessException {
        block7: {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            TransactionStatus status = this.ordersConsumerTransactionManager.getTransaction((TransactionDefinition)def);
            try {
                OrdersDto order = this.ordersSimpleService.select4updatelock(orderId, consumerId);
                if ("consume_success".equals(order.getStatus()) && "pay_success".equals(order.getConsumerPayStatus())) {
                    int ret = this.ordersStatusChangeService.doAmbStatusAfterSend(orderId, consumerId);
                    if (ret == 0) {
                        throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                    }
                    break block7;
                }
                throw new BusinessException("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c");
            }
            catch (Exception e1) {
                status.setRollbackOnly();
                throw e1;
            }
            finally {
                this.ordersConsumerTransactionManager.commit(status);
                this.orderSyncService.sync(orderId, consumerId);
            }
        }
        return true;
    }
}

