/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.activity;

import cn.com.duiba.order.center.biz.entity.ActivityOrderEntity;
import cn.com.duiba.order.center.biz.handle.ActivityOrderHandle;
import cn.com.duiba.order.center.biz.service.activity.DataSyncActivityOrderService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityOrderService {
    @Autowired
    private ActivityOrderHandle activityOrderHandle;
    @Autowired
    private DataSyncActivityOrderService dataSyncActivityOrderService;

    public String createOrder(ActivityOrderEntity entity) {
        this.activityOrderHandle.insert(entity);
        this.dataSyncActivityOrderService.dataSync(entity.getOrderNum());
        return entity.getOrderNum();
    }

    public ActivityOrderEntity findByOrderNum(String orderNum) {
        return this.activityOrderHandle.find(orderNum);
    }

    public boolean consumeCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
        int ret = this.activityOrderHandle.updateCreditsSuccess(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    public boolean consumeCreditsSuccessDowngrade(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
        int ret = this.activityOrderHandle.updateCreditsSuccessDowngrade(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    public boolean addCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
        int ret = this.activityOrderHandle.updateAddCreditsSuccess(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    public boolean consumeCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
        int ret = this.activityOrderHandle.updateCreditsFail(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    public boolean addCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
        int ret = this.activityOrderHandle.updateAddCreditsFail(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    public boolean addCreditsStatusToProcessing(String orderNum) {
        int ret = this.activityOrderHandle.addCreditsStatusToProcessing(orderNum);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    public boolean exchangeStatusToWait(String orderNum) {
        int ret = this.activityOrderHandle.updateExchangeStatusWait(orderNum);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    public boolean exchangeStatusToSuccess(String orderNum) {
        int ret = this.activityOrderHandle.updateExchangeStatusSuccess(orderNum);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    public boolean exchangeStatusToFail(String orderNum) {
        int ret = this.activityOrderHandle.updateExchangeStatusFail(orderNum);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    public boolean exchangeStatusToOverdue(String orderNum) {
        int ret = this.activityOrderHandle.updateExchangeStatusOverdue(orderNum);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    public boolean updateDeveloperBizId(String orderNum, String developerBizId) {
        int ret = this.activityOrderHandle.updateDeveloperBizId(orderNum, developerBizId);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    public boolean updateAddDeveloperBizId(String orderNum, String developerBizId) {
        int ret = this.activityOrderHandle.updateAddDeveloperBizId(orderNum, developerBizId);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    public boolean updateMainOrderNum(String orderNum, String mainOrderNum) {
        int ret = this.activityOrderHandle.updateMainOrderNum(orderNum, mainOrderNum);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }

    public Integer findConsumerDuibaActivityNum(long consumerId, long duibaActivityId, String activityType) {
        return this.activityOrderHandle.countConsumerJoinNum(consumerId, duibaActivityId, activityType);
    }

    public List<ActivityOrderEntity> findConsumerDuibaActivityNumList(long consumerId, List<Long> duibaActivityIds, String activityType) {
        return this.activityOrderHandle.findConsumerJoinList(consumerId, duibaActivityIds, activityType);
    }

    public ActivityOrderEntity findConsumerDuibaActivity4day(long consumerId, Long duibaActivityId, String activityType, String start, String end) {
        return this.activityOrderHandle.findConsumerDuibaActivity4day(consumerId, duibaActivityId, activityType, start, end);
    }

    public List<ActivityOrderEntity> findByOrderNums(long consumerId, List<String> orderNums) {
        return this.activityOrderHandle.findByOrderNums(consumerId, orderNums);
    }

    public List<String> findByExpirationTime(String expirationTime, String activityType) {
        return this.activityOrderHandle.findByExpirationTime(expirationTime, activityType);
    }

    public List<Long> findOptionIds(Long consumerId, Long appId, String activityType) {
        return this.activityOrderHandle.findOptionIds(consumerId, appId, activityType);
    }

    public List<ActivityOrderEntity> findByAppIdWithPage(Map<String, Object> queryMap) {
        return this.activityOrderHandle.findByAppIdWithPage(queryMap);
    }

    public Integer getCountByAppId(Map<String, Object> queryMap) {
        return this.activityOrderHandle.getCountByAppId(queryMap);
    }

    public List<Map<String, Long>> findFailByActivity4App(List<Long> activityIds, Long appId) {
        return this.activityOrderHandle.findFailByActivity4App(activityIds, appId);
    }

    public Boolean updateAddCredits(String orderNum, Long credits) {
        int ret = this.activityOrderHandle.updateAddCredits(orderNum, credits);
        if (ret < 1) {
            return false;
        }
        this.dataSyncActivityOrderService.dataSync(orderNum);
        return true;
    }
}

