package cn.com.duiba.trade.center.common.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

public class IdGenerator {
	private static final long STEP=10000;
	private static int times=new Random().nextInt(100);
	private static SimpleDateFormat format=new SimpleDateFormat("yyyyMMddHHmmssSSS");
	private static Long atomic=new Long(times*STEP);
	public static final String chash = "C";
	public static synchronized String generate(){
		Date date=new Date();
		String id=format.format(date);
		Long value=++atomic;
		if(atomic>=10000000){
			atomic=new Long(times*STEP);
		}
		String v=value.toString();
		while(v.length()<8){
			v="0"+v;
		}
		return id+v;
	}
	
	public static String generate(long id, long consumerId) {
		String tableSuffix = get1024Suffix(consumerId);
		return id + chash + tableSuffix;
	}
	
	private static String get1024Suffix(long consumerId) {
		long tbInt = consumerId % 1024;
		String tb = tbInt + "";
		if (tbInt < 10) {
			tb = "000" + tbInt;
		} else if (tbInt < 100) {
			tb = "00" + tbInt;
		} else if (tbInt < 1000) {
			tb = "0" + tbInt;
		}
		return tb;
	}
	
}
