package cn.com.duiba.trade.center.common.util;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by xuezhaoming on 16/6/8.
 */
public final class TableHelper {

    private static final int TABLES = 1024;

    public static Map<String, Object> getTbSuffixParamsMap(Long consumerId) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("tb_suffix", getTableSuffix(consumerId));
        return params;
    }

    public static String getTableSuffix(Long consumerId) {
        Long tbInt = consumerId.longValue() % TABLES;
        String tb = tbInt + "";
        if (tbInt < 10) {
            tb = "000" + tbInt;
        } else if (tbInt < 100) {
            tb = "00" + tbInt;
        } else if (tbInt < 1000) {
            tb = "0" + tbInt;
        }

        return tb;
    }

    public static String subString(String str, int maxLen) {

        return StringUtils.substring(str, 0, maxLen);
    }
}
