package cn.com.duiba.tuia.activity.center.api.constant.adx;

import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;

import java.util.Objects;

/**
 * 小恩爱ADX广告位类型枚举
 *
 * @author lixin
 * @date 2019/8/13 16:47
 **/
public enum XiaoEnAiSpecEnum {

    /** 开屏 */
    XIAO_EN_AI_001("001", "开屏", 20, "", "开屏",
            640, 960, 1, 140, "jpg/jpeg/png", null),

    /** banner */
    XIAO_EN_AI_002("002", "Banner", 21, "", "Banner",
            1536, 440, 1, 140, "jpg/jpeg/png", null),

    /** 信息流：三图 */
    XIAO_EN_AI_003("003", "信息流", 22, "1-4", "三图",
            300, 300, 3, 140, "jpg/jpeg/png", 33),

    /** 信息流：单图 */
    XIAO_EN_AI_004("003", "信息流", 23, "1-1", "单图",
            960, 640, 1, 140, "jpg/jpeg/png", 33),

    /** 信息流：图文摘要 */
    XIAO_EN_AI_005("003", "信息流", 24, "1-2", "图文摘要",
            960, 640, 1, 140, "jpg/jpeg/png", 33),

    /** 评论页：三图 */
    XIAO_EN_AI_006("004", "评论页", 25, "", "三图评论页",
            960, 640, 3, 140, "jpg/jpeg/png", 33),

    /** 评论页：单图 */
    XIAO_EN_AI_007("004", "评论页", 26, "", "单图评论页",
            960, 640, 1, 140, "jpg/jpeg/png", 33),


    /*********************** 美数 start ******************/

    /** 美数： 美数banner*/
    A_PUS_008("005", "美数-banner", 27, "", "图片",
            640, 288, 1, 150, "jpg/jpeg/png/gif", null),

    /** 美数： 美数插屏*/
    A_PUS_009("006", "美数-插屏", 28, "", "大图",
            640, 960, 1, 150, "jpg/png", null),

    /** 美数： 美数插屏*/
    A_PUS_010("006", "美数-插屏", 29, "", "小图",
            600, 500, 1, 150, "jpg/jpeg/png/gif", null),

    /** 美数： 美数横屏 */
    A_PUS_011("007", "美数-横屏", 30, "", "图片",
            640, 100, 1, 150, "jpg/jpeg/png/gif", null),

    /** 美数：一图一文 */
    A_PUS_012("008", "美数-一图一文", 31, "", "小图",
            160, 160, 1, 20, "png", 10),
    /** 美数：一图一文 */
    A_PUS_013("008", "美数-一图一文", 32, "", "中图",
                      300, 200, 1, 150, "jpg/jpeg/png", 20),
    /** 美数：一图一文 */
    A_PUS_014("008", "美数-一图一文", 33, "", "大图",
                      640, 360, 1, 150, "jpg/jpeg/png/gif", 30)

    /*********************** 美数 end ******************/


    /***********************apus start******************/

//    /** apus信息流：大图 */
//    A_PUS_008("005", "APUS-信息流", 27, "", "大图",
//            600, 400, 1, 150, "jpg/png", 30),
//    /** apus信息流：icon */
//    A_PUS_009("005", "APUS-信息流", 28, "", "icon",
//            200, 200, 1, 150, "jpg/png", 30),
//
//    /** apus开屏： */
//    A_PUS_010("006", "APUS-开屏", 29, "", "大图",
//            1080, 1920, 1, 150, "jpg/png", 30),
//
//
//    /** apus插屏： */
//    A_PUS_011("007", "APUS-插屏", 30, "", "大图",
//            600, 400, 1, 150, "jpg/png", 30),
//    /** apus插屏： */
//    A_PUS_012("007", "APUS-插屏", 31, "", "icon",
//            200, 200, 1, 150, "jpg/png", 30),
//
//
//    /** apus原生： */
//    A_PUS_013("008", "APUS-原生", 26, "", "大图",
//            600, 400, 1, 150, "jpg/png", 30),
//    /** apus原生： */
//    A_PUS_014("008", "APUS-原生", 26, "", "icon",
//            200, 200, 1, 150, "jpg/png", 30),
//    /** apus原生： */
//    A_PUS_015("008", "APUS-原生", 26, "", "开屏",
//            600, 400, 1, 150, "jpg/png", 30)

    /***********************apus end******************/

    ;

    /** 图文摘要的摘要字数限制 */
    public static final Integer CONTENT_LIMIT = 33;

    /** 广告类型编码 */
    private String specCode;

    /** dsp侧广告类型名称 */
    private String name;

    /** 规格样式 */
    private Integer styleStandard;

    /** 广告样式 */
    private String template;

    /** 广告样式描述 */
    private String templateDescription;

    /** 素材宽度 */
    private Integer picW;

    /** 素材高度 */
    private Integer picH;

    /** 素材个数 */
    private Integer picNum;

    /** 素材大小 */
    private Integer size;

    /** 素材格式 */
    private String picType;

    /** 标题限制字数 */
    private Integer titleLimit;

    /**
     * constructor
     *
     * @param specCode
     * @param name
     * @param styleStandard
     * @param template
     * @param templateDescription
     * @param picW
     * @param picH
     * @param picNum
     * @param size
     * @param picType
     * @param titleLimit
     */
    XiaoEnAiSpecEnum(String specCode, String name, Integer styleStandard, String template, String templateDescription,
                     Integer picW, Integer picH, Integer picNum, Integer size, String picType, Integer titleLimit) {
        this.specCode = specCode;
        this.name = name;
        this.styleStandard = styleStandard;
        this.template = template;
        this.templateDescription = templateDescription;
        this.picW = picW;
        this.picH = picH;
        this.picNum = picNum;
        this.size = size;
        this.picType = picType;
        this.titleLimit = titleLimit;
    }

    public String getName() {
        return name;
    }

    public Integer getStyleStandard() {
        return styleStandard;
    }

    public String getTemplate() {
        return template;
    }

    public String getTemplateDescription() {
        return templateDescription;
    }

    public String getSpecCode() {
        return specCode;
    }

    public Integer getPicW() {
        return picW;
    }

    public Integer getPicH() {
        return picH;
    }

    public Integer getSize() {
        return size;
    }

    public String getPicType() {
        return picType;
    }

    public Integer getTitleLimit() {
        return titleLimit;
    }

    public Integer getPicNum() {
        return picNum;
    }

    /**
     * 根据styleStandard查询对应的枚举
     *
     * @param styleStandard
     * @return
     */
    public static XiaoEnAiSpecEnum getEnumByStyleStandard(Integer styleStandard) {
        if (Objects.isNull(styleStandard)) {
            return null;
        }

        for (XiaoEnAiSpecEnum specEnum : XiaoEnAiSpecEnum.values()) {
            if (Objects.equals(styleStandard, specEnum.getStyleStandard())) {
                return specEnum;
            }
        }
        return null;
    }

    /**
     * 判断当前创意是否是信息流
     *
     * @param ideaDto
     * @return
     */
    public static boolean isInfoFlow(ResourceIdeaDto ideaDto) {
        if (Objects.isNull(ideaDto) || Objects.isNull(ideaDto.getStyleStandard())) {
            return false;
        }

        XiaoEnAiSpecEnum specEnum = XiaoEnAiSpecEnum.getEnumByStyleStandard(ideaDto.getStyleStandard());
        return Objects.nonNull(specEnum) &&
                (specEnum == XiaoEnAiSpecEnum.XIAO_EN_AI_003
                        || specEnum == XiaoEnAiSpecEnum.XIAO_EN_AI_004
                        || specEnum == XiaoEnAiSpecEnum.XIAO_EN_AI_005);
    }
}
