package cn.com.duiba.tuia.activity.center.api.constant.adx;

import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;

import java.util.Objects;

/**
 * 小恩爱ADX广告位类型枚举
 *
 * @author lixin
 * @date 2019/8/13 16:47
 **/
public enum XiaoEnAiSpecEnum {

    /** 开屏 */
    XIAO_EN_AI_001("001", "开屏", 20, "", "开屏",
            640, 960, 140, "jpg/jpeg/png", 33),

    /** banner */
    XIAO_EN_AI_002("002", "Banner", 21, "", "Banner",
            1536, 440, 140, "jpg/jpeg/png", 33),

    /** 信息流：三图 */
    XIAO_EN_AI_003("003", "信息流", 22, "1-4", "三图",
            300, 300, 140, "jpg/jpeg/png", 33),

    /** 信息流：单图 */
    XIAO_EN_AI_004("003", "信息流", 23, "1-1", "单图",
            960, 640, 140, "jpg/jpeg/png", 33),

    /** 信息流：图文摘要 */
    XIAO_EN_AI_005("003", "信息流", 24, "1-2", "图文摘要",
            960, 640, 140, "jpg/jpeg/png", 33),

    /** 评论页：三图 */
    XIAO_EN_AI_006("004", "评论页", 25, "", "三图评论页",
            960, 640, 140, "jpg/jpeg/png", 33),

    /** 评论页：单图 */
    XIAO_EN_AI_007("004", "评论页", 26, "", "单图评论页",
            960, 640, 140, "jpg/jpeg/png", 33);

    /** 图文摘要的摘要字数限制 */
    public static final Integer CONTENT_LIMIT = 33;

    /** 广告类型编码 */
    private String specCode;

    /** dsp侧广告类型名称 */
    private String name;

    /** 规格样式 */
    private Integer styleStandard;

    /** 广告样式 */
    private String template;

    /** 广告样式描述 */
    private String templateDescription;

    /** 素材宽度 */
    private Integer picW;

    /** 素材高度 */
    private Integer picH;

    /** 素材大小 */
    private Integer size;

    /** 素材格式 */
    private String picType;

    /** 标题限制字数 */
    private Integer titleLimit;

    /**
     * constructor
     *
     * @param specCode
     * @param name
     * @param styleStandard
     * @param template
     * @param templateDescription
     * @param picW
     * @param picH
     * @param size
     * @param picType
     * @param titleLimit
     */
    XiaoEnAiSpecEnum(String specCode, String name, Integer styleStandard, String template, String templateDescription,
                     Integer picW, Integer picH, Integer size, String picType, Integer titleLimit) {
        this.specCode = specCode;
        this.name = name;
        this.styleStandard = styleStandard;
        this.template = template;
        this.templateDescription = templateDescription;
        this.picW = picW;
        this.picH = picH;
        this.size = size;
        this.picType = picType;
        this.titleLimit = titleLimit;
    }

    public String getName() {
        return name;
    }

    public Integer getStyleStandard() {
        return styleStandard;
    }

    public String getTemplate() {
        return template;
    }

    public String getTemplateDescription() {
        return templateDescription;
    }

    public String getSpecCode() {
        return specCode;
    }

    public Integer getPicW() {
        return picW;
    }

    public Integer getPicH() {
        return picH;
    }

    public Integer getSize() {
        return size;
    }

    public String getPicType() {
        return picType;
    }

    public Integer getTitleLimit() {
        return titleLimit;
    }

    /**
     * 根据styleStandard查询对应的枚举
     *
     * @param styleStandard
     * @return
     */
    public static XiaoEnAiSpecEnum getEnumByStyleStandard(Integer styleStandard) {
        if (Objects.isNull(styleStandard)) {
            return null;
        }

        for (XiaoEnAiSpecEnum specEnum : XiaoEnAiSpecEnum.values()) {
            if (Objects.equals(styleStandard, specEnum.getStyleStandard())) {
                return specEnum;
            }
        }
        return null;
    }

    /**
     * 判断当前创意是否是信息流
     *
     * @param ideaDto
     * @return
     */
    public static boolean isInfoFlow(ResourceIdeaDto ideaDto) {
        if (Objects.isNull(ideaDto) || Objects.isNull(ideaDto.getStyleStandard())) {
            return false;
        }

        XiaoEnAiSpecEnum specEnum = XiaoEnAiSpecEnum.getEnumByStyleStandard(ideaDto.getStyleStandard());
        return Objects.nonNull(specEnum) &&
                (specEnum == XiaoEnAiSpecEnum.XIAO_EN_AI_003
                        || specEnum == XiaoEnAiSpecEnum.XIAO_EN_AI_004
                        || specEnum == XiaoEnAiSpecEnum.XIAO_EN_AI_005);
    }
}
