package cn.com.duiba.tuia.activity.center.api.dto.advert_statistics;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 海选数据回流表DO对象
 * @author miaohongshuai
*/
@Data
public class ActivityTitlePreSelectDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 1：活动海选  2：皮肤海选  3、广告位皮肤海选
     */
    private Integer type;

    /**
    * 活动ID type=2、3 ：取值=-1 ，type=1：取值 activity_id
    */
    private Long activityId;

    /**
    * 皮肤ID type=1 ：取值=-1  ， type=2、3：取值 activity_skin
    */
    private Long activitySkin;

    /**
    * 广告位ID
    */
    private Long slotId;

    /**
    * 活动主标题id，不可为null
    */
    private Long activityTitleId;

    /**
    * 活动子标题id，可为null
    */
    private Long activitySubTitleId;

    /**
     * 海选排序分
     */
    private Double score;

    /**
     * 海选排名
     */
    private Long rank;

    /**
     * 数据回流日期
     */
    private Date dt;
}

