package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.algo.*;

import java.util.List;

/**
 * 算法标题
 */
@AdvancedFeignClient
public interface RemoteActivityAlgoTitleService {

    /**
     * 算法标题 查询列表
     * @param req
     * @return
     */
    PageDto<ActivitySkinTitleDTO> getActivityTitleList(ActivitySkinTitleReqDTO req);

    /**
     * 算法标题 新增
     * @param req
     * @return
     */
    int saveActivityTitle(ActivitySkinTitleDTO req);

    /**
     * 算法标题 修改
     * @param req
     * @return
     */
    int updateActivityTitle(ActivitySkinTitleDTO req);

    /**
     * 算法标题 查询详情
     * @param id
     * @return
     */
    ActivitySkinTitleDTO getActivityTitleDetail(Long id);

    /**
     * 标题定向关系处理，查询返回列表，上游自己根据orientType分组，或orientId查询----------------
     */
    List<ActivitySkinTitleOrientDTO> getActivityTitleOrientList(ActivitySkinTitleOrientDTO req);

    /**
     * 标签关联关系修改
     */
    Boolean updateActivityTitleOrient(List<ActivitySkinTitleOrientDTO> reqList);

    /**
     * 标签关联关系查询，主副标签是两套的------------------------------------------------------
     */
    List<ActivityTitleFirstTagDTO> getActivityTitleTagList();

    /**
     * 标签关联关系修改
     */
    Boolean updateActivityTitleTag(ActivityTitleFirstTagDTO req);


    /**
     * 算法标题列表 查询
     * @param ids
     * @return
     */
    List<ActivitySkinTitleDTO> listActivityTitleDetail(List<Long> ids);

    /**
     * 根据皮肤类型和媒体行业标签id 获取定向的标题列表
     * @param templateType
     * @param mediaTagId
     * @return
     */
    List<ActivityTitleAlgoOrientDTO> listOrientTitles(Integer templateType, Long mediaTagId);

    /**
     * 根据皮肤类型和媒体行业标签id 获取可用的标题列表
     * @param templateType
     * @param mediaTagId
     * @return
     */
    List<ActivityTitleAlgoOrientDTO> listCanUseActivityTitles(Integer templateType, Long mediaTagId);
}
