package cn.com.duiba.tuia.activity.center.api.constant.adx;

import java.util.List;
import java.util.Objects;

/**
 * 爱奇艺广告位类型
 * 信息流(大图)14、浮层10、MOB焦点图-图片18、MOB-5s贴片 1、MOB-暂停 14、MOB-信息流(双图) 6
 * MOB视频关联位-图片 13、
 *
 * @author lixin
 * @date 2019/9/23 16:35
 **/
public enum IQiYiSpecEnum {

    /**
     * 信息流(大图) 14
     */
    I_QI_YI_SPEC_001("IQI001", "信息流(大图)", 40, "5000000000174",
            "信息流新大图", 600, 300, 80, "JPG,PNG", 18, 6, 14),

    /**
     * 浮层10
     */
    I_QI_YI_SPEC_002("IQI002", "浮层", 41, null,
            null, 160, 160, 500, "GIF,JPG,PNG", 20, 30, 10),

    /**
     * MOB焦点图-图片 18
     */
    I_QI_YI_SPEC_003("IQI003", "焦点图-图片", 42, "5000000000174",
            "信息流新大图", 600, 300, 80, "JPG,PNG", 20, 30, 18),

    /**
     * MOB-5s贴片 1
     */
    I_QI_YI_SPEC_005("IQI005", "贴片5s", 44, "",
            "5s贴片", 1280, 720, 80, "JPG,PNG", 20, 30, 1),

    /**
     * MOB-暂停 2 · 纯图·1
     */
    I_QI_YI_SPEC_006("IQI006", "纯图·1", 45, "",
            "纯图·1", 600, 500, 120, "JPG,PNG", 20, 30, 2),

    /**
     * MOB-暂停 2 · 纯图·2
     */
    I_QI_YI_SPEC_010("IQI006", "纯图·2", 49, "",
            "纯图·2", 668, 374, 120, "JPG,PNG", 20, 30, 2),

    /**
     * MOB-暂停 2 · 纯图·3
     */
    I_QI_YI_SPEC_011("IQI006", "纯图·3", 50, "",
            "纯图·3", 600, 300, 120, "JPG,PNG", 20, 30, 2),

    /**
     * MOB-暂停 2 · 视频
     */
    I_QI_YI_SPEC_012("IQI006", "视频", 51, "",
            "视频", 1280, 720, 120, "MP4", 20, 30, 2),

    /**
     * MOB-信息流(双图) 6
     */
    I_QI_YI_SPEC_007("IQI007", "信息流(双图)", 46, "",
            "信息流(双图)", 300, 170, 80, "JPG,PNG", 20, 30, 14),


    /**
     * 贴片15s 6
     */
    I_QI_YI_SPEC_008("IQI008", "贴片15s", 47, "",
            "贴片15s", 1280, 720, 200, "MP4", 20, 30, 1),


    /**
     * 触点贴片
     */
    I_QI_YI_SPEC_009("IQI009", "触点贴片", 48, "",
            "触点贴片", 1280, 720, 200, "MP4", 20, 30, 17),


    /**
     * MOB视频关联位-图片 13
     */
    I_QI_YI_SPEC_004("IQI004", "视频关联位-图片", 43, "5000000000129",
            "视频关联位-图片", 640, 120, 80, "JPG,PNG", 20, 30, 13);

    /**
     * 广告类型编码
     */
    private String specCode;

    /**
     * dsp侧广告类型名称
     */
    private String name;

    /**
     * 规格样式
     */
    private Integer styleStandard;

    /**
     * 广告样式
     */
    private String template;

    /**
     * 广告样式描述
     */
    private String templateDescription;

    /**
     * 素材宽度
     */
    private Integer picW;

    /**
     * 素材高度
     */
    private Integer picH;

    /**
     * 素材大小
     */
    private Integer size;

    /**
     * 素材格式
     */
    private String picType;

    /**
     * 标题限制字数
     */
    private Integer titleLimit;

    /**
     * 品牌名称限制字数
     */
    private Integer contentLimit;

    /**
     * 素材上传接口
     */
    private Integer adType;

    /**
     * 构造
     *
     * @param specCode
     * @param name
     * @param styleStandard
     * @param template
     * @param templateDescription
     * @param picW
     * @param picH
     * @param size
     * @param picType
     * @param titleLimit
     * @param contentLimit
     * @param adType
     */
    IQiYiSpecEnum(String specCode, String name, Integer styleStandard, String template, String templateDescription, Integer picW, Integer picH, Integer size, String picType, Integer titleLimit, Integer contentLimit, Integer adType) {
        this.specCode = specCode;
        this.name = name;
        this.styleStandard = styleStandard;
        this.template = template;
        this.templateDescription = templateDescription;
        this.picW = picW;
        this.picH = picH;
        this.size = size;
        this.picType = picType;
        this.titleLimit = titleLimit;
        this.contentLimit = contentLimit;
        this.adType = adType;
    }


    /**
     * 根据styleStandard查询规格
     *
     * @param styleStandard
     * @return
     */
    public static IQiYiSpecEnum getSpecEnumByStyleStandard(Integer styleStandard) {
        if (Objects.isNull(styleStandard)) {
            return null;
        }

        for (IQiYiSpecEnum specEnum : IQiYiSpecEnum.values()) {
            if (Objects.equals(specEnum.getStyleStandard(), styleStandard)) {
                return specEnum;
            }
        }
        return null;
    }

    public String getSpecCode() {
        return specCode;
    }

    public void setSpecCode(String specCode) {
        this.specCode = specCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStyleStandard() {
        return styleStandard;
    }

    public void setStyleStandard(Integer styleStandard) {
        this.styleStandard = styleStandard;
    }

    public String getTemplate() {
        return template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplateDescription() {
        return templateDescription;
    }

    public void setTemplateDescription(String templateDescription) {
        this.templateDescription = templateDescription;
    }

    public Integer getPicW() {
        return picW;
    }

    public void setPicW(Integer picW) {
        this.picW = picW;
    }

    public Integer getPicH() {
        return picH;
    }

    public void setPicH(Integer picH) {
        this.picH = picH;
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getPicType() {
        return picType;
    }

    public void setPicType(String picType) {
        this.picType = picType;
    }

    public Integer getTitleLimit() {
        return titleLimit;
    }

    public void setTitleLimit(Integer titleLimit) {
        this.titleLimit = titleLimit;
    }

    public Integer getContentLimit() {
        return contentLimit;
    }

    public void setContentLimit(Integer contentLimit) {
        this.contentLimit = contentLimit;
    }

    public Integer getAdType() {
        return adType;
    }

    public void setAdType(Integer adType) {
        this.adType = adType;
    }
}
