package cn.com.duiba.tuia.activity.center.api.constant.adx;

import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

/**
 * 美数 广告位类型枚举
 *
 * @author peanuthuang
 */
public enum MeishuSpecEnum {

    /** 美数： 美数banner*/
    MEI_SHU_001("001", "美数-banner", 27, "", "图片",
            Lists.newArrayList(640), Lists.newArrayList(288), 1, 150, "jpg/jpeg/png/gif", null, null),

    /** 美数： 美数插屏*/
    MEI_SHU_002("002", "美数-插屏 640*960", 28, "", "大图",
            Lists.newArrayList(640), Lists.newArrayList(960), 1, 150, "jpg/png", null, null),

    /** 美数： 美数插屏*/
    MEI_SHU_003("003", "美数-插屏 600*500", 29, "", "小图",
            Lists.newArrayList(600), Lists.newArrayList(500), 1, 150, "jpg/jpeg/png/gif", null, null),

    /** 美数： 美数横屏 */
    MEI_SHU_004("004", "美数-横屏", 30, "", "图片",
            Lists.newArrayList(640), Lists.newArrayList(100), 1, 150, "jpg/jpeg/png/gif", null, null),

    /** 美数：一图一文 */
    MEI_SHU_005("005", "美数-一图一文", 31, "1-1", "小图",
            Lists.newArrayList(160), Lists.newArrayList(160), 1, 20, "png", 10, null),
    /** 美数：一图一文 */
    MEI_SHU_006("005", "美数-一图一文", 32, "1-1", "中图",
            Lists.newArrayList(300), Lists.newArrayList(200), 1, 150, "jpg/jpeg/png", 20, null),
    /** 美数：一图一文 */
    MEI_SHU_007("005", "美数-一图一文", 33, "1-1", "大图",
            Lists.newArrayList(640), Lists.newArrayList(360), 1, 150, "jpg/jpeg/png/gif", 30, null),


    MEI_SHU_008("001", "美数-banner", 34, "", "Banner · 图片 ( 640 * 100 )",
            Lists.newArrayList(640), Lists.newArrayList(100), 1, 150, "jpg/jpeg/png", null, null),

    MEI_SHU_011("004", "美数-横屏", 35, "", "横屏 · 图片( 640 * 100 )",
            Lists.newArrayList(640), Lists.newArrayList(100), 1, 150, "jpg/jpeg/png/gif", null, null),

    MEI_SHU_009("006", "美数-开屏", 36, "", "开屏 · 图片 ( 640 * 960 , 展示 3s )",
            Lists.newArrayList(640), Lists.newArrayList(960), 1, 150, "jpg/jpeg/png", null, null),

    MEI_SHU_010("006", "美数-开屏", 37, "", "开屏 · 图片( 640 * 960 , 展示 5s )",
            Lists.newArrayList(640), Lists.newArrayList(960), 1, 150, "jpg/jpeg/png", null, null),

    MEI_SHU_012("007", "美数· 图文摘要", 38, "1-2", "底部 · Banner 信息流 ( 640 * 360 ).",
            Lists.newArrayList(640), Lists.newArrayList(360), 1, 150, "jpg/jpeg/png", 18, 25),

    MEI_SHU_013("007", "美数· 图文摘要", 39, "1-2", "章节中 · 大图信息流 ( 640 * 960 ). ",
            Lists.newArrayList(640), Lists.newArrayList(960), 1, 150, "jpg/jpeg/png/gif", 10, 15),

    MEI_SHU_014("007", "美数· 图文摘要", 40, "1-2", "章节末 · 信息流 ( 640 * 960 ). ",
            Lists.newArrayList(640), Lists.newArrayList(960), 1, 150, "jpg/jpeg/png/gif", 10, 15),
    ;

    /** 广告类型编码 */
    private String specCode;

    /** dsp侧广告类型名称 */
    private String name;

    /** 规格样式 */
    private Integer styleStandard;

    /** 广告样式 */
    private String template;

    /** 广告样式描述 */
    private String templateDescription;

    /** 素材宽度 */
    private List<Integer> picW;

    /** 素材高度 */
    private List<Integer> picH;

    /** 素材个数 */
    private Integer picNum;

    /** 素材大小 */
    private Integer size;

    /** 素材格式 */
    private String picType;

    /** 标题限制字数 */
    private Integer titleLimit;

    /** 描述字数限制 */
    private Integer contentLimit;

    /**
     * constructor
     * @param specCode
     * @param name
     * @param styleStandard
     * @param template
     * @param templateDescription
     * @param picW
     * @param picH
     * @param picNum
     * @param size
     * @param picType
     * @param titleLimit
     * @param contentLimit
     */
    MeishuSpecEnum(String specCode, String name, Integer styleStandard, String template, String templateDescription,
                     List<Integer> picW, List<Integer> picH, Integer picNum, Integer size, String picType, Integer titleLimit, Integer contentLimit) {
        this.specCode = specCode;
        this.name = name;
        this.styleStandard = styleStandard;
        this.template = template;
        this.templateDescription = templateDescription;
        this.picW = picW;
        this.picH = picH;
        this.picNum = picNum;
        this.size = size;
        this.picType = picType;
        this.titleLimit = titleLimit;
        this.contentLimit = contentLimit;
    }

    public String getName() {
        return name;
    }

    public Integer getStyleStandard() {
        return styleStandard;
    }

    public String getTemplate() {
        return template;
    }

    public String getTemplateDescription() {
        return templateDescription;
    }

    public String getSpecCode() {
        return specCode;
    }

    public List<Integer> getPicW() {
        return picW;
    }

    public List<Integer> getPicH() {
        return picH;
    }

    public Integer getSize() {
        return size;
    }

    public String getPicType() {
        return picType;
    }

    public Integer getTitleLimit() {
        return titleLimit;
    }

    public Integer getPicNum() {
        return picNum;
    }

    public Integer getContentLimit() { return contentLimit; }

    /**
     * 根据styleStandard查询对应的枚举
     *
     * @param styleStandard
     * @return
     */
    public static MeishuSpecEnum getEnumByStyleStandard(Integer styleStandard) {
        if (Objects.isNull(styleStandard)) {
            return null;
        }

        return Stream.of(MeishuSpecEnum.values()).filter(e -> e.getStyleStandard().equals(styleStandard)).findFirst().orElse(null);
    }


    /**
     * 判断当前创意是否是信息流
     *
     * @param ideaDto
     * @return
     */
    public static boolean isInfoFlow(ResourceIdeaDto ideaDto) {
        if (Objects.isNull(ideaDto) || Objects.isNull(ideaDto.getStyleStandard())) {
            return false;
        }

        MeishuSpecEnum specEnum = MeishuSpecEnum.getEnumByStyleStandard(ideaDto.getStyleStandard());
        return Objects.nonNull(specEnum) &&
                (specEnum == MeishuSpecEnum.MEI_SHU_005
                        || specEnum == MeishuSpecEnum.MEI_SHU_006
                        || specEnum == MeishuSpecEnum.MEI_SHU_007
                        || specEnum == MeishuSpecEnum.MEI_SHU_012
                        || specEnum == MeishuSpecEnum.MEI_SHU_013
                        || specEnum == MeishuSpecEnum.MEI_SHU_014
                );
    }

    /**
     * 判断当前创意是否是摘要
     *
     * @param ideaDto
     * @return
     */
    public static boolean isSummary(ResourceIdeaDto ideaDto) {
        if (Objects.isNull(ideaDto) || Objects.isNull(ideaDto.getStyleStandard())) {
            return false;
        }

        MeishuSpecEnum specEnum = MeishuSpecEnum.getEnumByStyleStandard(ideaDto.getStyleStandard());
        return Objects.nonNull(specEnum) &&
                (specEnum == MeishuSpecEnum.MEI_SHU_012
                        || specEnum == MeishuSpecEnum.MEI_SHU_013
                        || specEnum == MeishuSpecEnum.MEI_SHU_014
                );
    }
}
