package cn.com.duiba.tuia.activity.center.api.dto.algo;

import cn.com.duiba.tuia.activity.center.api.dto.req.ReqPageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * 字符串裁剪tof
 *
 * @date 2020-02-13 10:55:35
 */
@Data
@ToString
@EqualsAndHashCode(callSuper = false)
public class ActivitySkinTitleCutDTO extends ReqPageQuery {
    private static final long serialVersionUID = 8578506649549761213L;

    private Long id;

    /**
     * 字体包分类：0原始包，1裁剪包
     */
    private Integer isOrigin;
    /**
     * 默认0不是动态词包，1是动态词包
     */
    private Integer isDynamics;
    /**
     * 字体类型：1.宋体，2黑体
     */
    private Integer fontType;
    /**
     * 宋体
     */
    private String fontTypeName;
    /**
     * 字符串：天天送红包，{节日}送好礼，动态词库
     */
    private String titleContent;
    /**
     * 裁剪文本，如动态词库储备，天天送好礼
     */
    private String titleCutText;
    /**
     * 上传到cdn的地址
     */
    private String cdnUrl;

    /**
     * 字体库的大小
     */
    private Integer cdnSizeKb;

    /**
     * 记录创建时间
     */
    private Date gmtCreate;
    /**
     * 记录修改时间
     */
    private Date gmtModified;
    /**
     * 是否删除（1：删除 0：正常，上线）
     */
    private Integer isDeleted;

}
