package cn.com.duiba.tuia.activity.center.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.adx.audit.AdxAuditDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.audit.AuditStatusRspDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.audit.DirectlyAuditRecordDto;

/**
 * adx 素材审核服务
 *
 * @author peanut.huang
 * @date 2020/2/4 14:18
 */
@AdvancedFeignClient
public interface RemoteAdxAuditService {

    /**
     * adx 素材送审
     *
     * @param auditDto
     * @return
     */
    AuditStatusRspDto audit(AdxAuditDto auditDto);

    /**
     * 获取审核状态
     *
     * @param adxType adx
     * @param auditId 审核id
     * @return
     */
    AuditStatusRspDto auditResult(Integer adxType, Long auditId);

    /**
     * 审核id获取审核记录
     *
     * @param directlyAuditId 直投审核id
     * @return
     */
    DirectlyAuditRecordDto selectByDirectlyAuditId(Long directlyAuditId);
}
