package cn.com.duiba.tuia.activity.center.api.dto.adx.audit;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class AdvertiserAuditStatusDto implements Serializable {

    private static final long serialVersionUID = 661661104405556373L;

    /**
     * 广告主id
     */
    @NotNull(message = "广告主id不能为空")
    private Long advertiserId;

    /**
     * 广告主名
     */
    @NotBlank(message = "广告主名称不能为空")
    private String advertiserName;

    /**
     * adx类型
     */
    @NotNull(message = "adx类型不能为空")
    private Integer adxType;

    /**
     * 企业/个体营业执照
     */
    private String businessLicense;

    /**
     * 计算机软件著作权登记证书
     */
    private String registerCredential;

    /**
     * 涉及售卖药品、医疗器械等特殊产品需要提供特殊资质，如《互联网药品信息服务资格证书》,涉 及网络文化等 APP 广告须提交以下证明文件《网络视听许可证》、《广播电视节目制作经营许可证》
     */
    private String qualification;

    /**
     * 法律、法规规定的及其他确认广告内容真实性的证明文件
     */
    private String documentaryEvidence;

    /**
     * 送审原因(0-落地页变更,1-素材内部审核通过,2-广告主资质变更)
     */
    @NotNull(message = "送审原因不能为空")
    private Integer auditReason;

    /**
     * 批次标识符
     */
    @NotBlank(message = "批次标识符不能为空")
    private String batchId;

}
