package cn.com.duiba.tuia.activity.center.api.req.adx;

import java.io.Serializable;

/**
 * 〈一句话功能简述〉<br>
 * Description: adx曝光成功记录信息
 *
 * @author hillchen
 * @create 2019/2/27 00:48
 */

public class AdxSuccBidInfo implements Serializable {

    private static final long serialVersionUID = 6996300130162900166L;

    /**
     * adx全链路请求标示
     */
    private String adxRid;

    /**
     * adx平台广告位id
     */
    private String tagId;
    /**
     * 广告位索引
     */
    private String tagIndex;

    /**
     * 资源位id
     */
    private Long resourceId;

    /**
     * 创意id
     */
    private Long ideaId;


    /**
     * 对应tuia的广告位id
     */
    private Long slotId;

    /**
     * 对应tuia的应用id
     */
    private Long addId;

    /**
     * 标准出价:分/1000次
     */
    private Long bidPrice;

    /**
     * 标准扣费:分/1000次
     */
    private Long feePrice;

    /**
     * 创意投放方式：0:依次投放,1:按比例投放
     */
    private Integer putType;

    /**
     * 出价类型0:人工出价,1:算法出价
     */
    private Integer priceType;

    /**
     * 计费方式：0:cpc，1:cpm（现有的adx都是cpm计费方式）
     */
    private Integer billType;

    /**
     * 扣费方式：1:一价扣费，2:二价扣费
     */
    private Integer feeType;

    /**
     * 记录状态：0:竞价返回，1:竞价成功，2:创意曝光，3:创意点击
     */
    private Integer recodeStatus;

    /** adxPriceLevel */
    private Integer adxPriceLevel;

    /** isCompareGroup */
    private String isCompareGroup;

    /** 策略类型 */
    private String strategy;

    /** 试探level */
    private String level;

    /** 拓展字段（map转string存入，防止反序列化时出现异常） */
    private String extMap;

    /** 策略类型 每个数字代表一个算法模型 示例 1 */
    private String algType;

    /** 推广组ID */
    private String adxGroupId;

    /**
     * 经纬度
     */
    private Double longitude;

    /**
     * 经纬度
     */
    private Double latitude;

    /**
     * 经纬度hash
     */
    private String geohash;

    /** 推广组ID */
    private String groupId;

    /** 1:预发券 2:非预发券 **/
    private Integer preLaunch;

    /** 0-免费 1-付费 **/
    private Integer appPaid;

    /** 0.测试组 1.对照组 **/
    private Integer isTestGroup;

    public String getTagIndex() {
        return tagIndex;
    }

    public void setTagIndex(String tagIndex) {
        this.tagIndex = tagIndex;
    }

    public String getAdxRid() {
        return adxRid;
    }

    public void setAdxRid(String adxRid) {
        this.adxRid = adxRid;
    }

    public String getTagId() {
        return tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public Long getIdeaId() {
        return ideaId;
    }

    public void setIdeaId(Long ideaId) {
        this.ideaId = ideaId;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getAddId() {
        return addId;
    }

    public void setAddId(Long addId) {
        this.addId = addId;
    }

    public Long getBidPrice() {
        return bidPrice;
    }

    public void setBidPrice(Long bidPrice) {
        this.bidPrice = bidPrice;
    }

    public Long getFeePrice() {
        return feePrice;
    }

    public void setFeePrice(Long feePrice) {
        this.feePrice = feePrice;
    }

    public Integer getPutType() {
        return putType;
    }

    public void setPutType(Integer putType) {
        this.putType = putType;
    }

    public Integer getPriceType() {
        return priceType;
    }

    public void setPriceType(Integer priceType) {
        this.priceType = priceType;
    }

    public Integer getBillType() {
        return billType;
    }

    public void setBillType(Integer billType) {
        this.billType = billType;
    }

    public Integer getFeeType() {
        return feeType;
    }

    public void setFeeType(Integer feeType) {
        this.feeType = feeType;
    }

    public Integer getRecodeStatus() {
        return recodeStatus;
    }

    public void setRecodeStatus(Integer recodeStatus) {
        this.recodeStatus = recodeStatus;
    }

    public Integer getAdxPriceLevel() {
        return adxPriceLevel;
    }

    public void setAdxPriceLevel(Integer adxPriceLevel) {
        this.adxPriceLevel = adxPriceLevel;
    }

    public String getIsCompareGroup() {
        return isCompareGroup;
    }

    public void setIsCompareGroup(String isCompareGroup) {
        this.isCompareGroup = isCompareGroup;
    }

    public String getStrategy() {
        return strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getExtMap() {
        return extMap;
    }

    public void setExtMap(String extMap) {
        this.extMap = extMap;
    }

    public String getAlgType() {
        return algType;
    }

    public void setAlgType(String algType) {
        this.algType = algType;
    }

    public String getAdxGroupId() {
        return adxGroupId;
    }

    public void setAdxGroupId(String adxGroupId) {
        this.adxGroupId = adxGroupId;
    }

    public Double getLatitude() {
        return latitude;
    }

    public void setLatitude(final Double latitude) {
        this.latitude = latitude;
    }

    public String getGeohash() {
        return geohash;
    }

    public void setGeohash(final String geohash) {
        this.geohash = geohash;
    }

    public Double getLongitude() {
        return longitude;
    }

    public void setLongitude(final Double longitude) {
        this.longitude = longitude;
    }

    public Integer getPreLaunch() {
        return preLaunch;
    }

    public void setPreLaunch(Integer preLaunch) {
        this.preLaunch = preLaunch;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Integer getAppPaid() {
        return appPaid;
    }

    public void setAppPaid(Integer appPaid) {
        this.appPaid = appPaid;
    }

    public Integer getIsTestGroup() {
        return isTestGroup;
    }

    public void setIsTestGroup(Integer isTestGroup) {
        this.isTestGroup = isTestGroup;
    }

    /**
     * 扩展map的key
     */
    public static class ExtMapKey {

        /** 预发券入参的key */
        public static String PRE_LOAD_ADVERT_PARAMS = "preLoadAdvertParams";
    }
}