package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.PopularGroupDiDto;
import cn.com.duiba.tuia.activity.center.api.dto.ResourceIdeaDiDto;
import cn.com.duiba.tuia.activity.center.api.dto.ResourceLocationDiDto;
import cn.com.duiba.tuia.activity.center.api.dto.XunfeiDeviceStatisDto;
import cn.com.duiba.tuia.activity.center.api.dto.req.ResourceLocationDiPageReq;

import java.util.List;

/**
 * @author weny.cai
 * @version 1.0
 * @description 讯飞
 * @date 2018/8/1 10:41
 **/
@AdvancedFeignClient
public interface RemoteXunfeiDeviceStatisService {

    /**
     * @description: 查询数据
     * @param curDate
     * @return List<XunfeiDeviceStatisDto>
     * @author weny.cai
     * @date 2018/8/1 10:44
     */
    List<XunfeiDeviceStatisDto> selectXunfeiDevice(String curDate,int offset, int max);

    /**
     * 推广组数据
     * @param startDate
     * @param endDate
     * @return
     */
    List<PopularGroupDiDto> selectGroupDataByDate(String startDate,String endDate);

    /**
     * 资源位数据
     * @param startDate
     * @param endDate
     * @return
     */
    List<ResourceLocationDiDto> selectResourceDataByDate(String startDate,String endDate);

    /**
     * 创意数据
     * @param startDate
     * @param endDate
     * @return
     */
    List<ResourceIdeaDiDto> selectIdeaDataByDate(String startDate, String endDate);


    /**
     * 创意数据
     * @param deliveryGroupList 投放组
     * @param ideaIdList 创意集合
     * @param startDate 开始日期
     * @param endDate 结束日期
     * @return 报表统计
     */
    List<ResourceIdeaDiDto> selectIdeaDataByDateAndDeliveryGroup(List<Byte> deliveryGroupList, List<Long> ideaIdList, String startDate, String endDate);

    /**
     * 功能描述 资源位数据，并进行排序
     * @author shenjiaqing
     * @date 17:01 2020/5/11
     * @param [startDate, endDate]
     * @return java.util.List<cn.com.duiba.tuia.activity.center.api.dto.ResourceLocationDiDto>
     **/
    List<ResourceLocationDiDto> selectResourceDataByDateAndSort(ResourceLocationDiPageReq req);



}
