package cn.com.duiba.tuia.activity.center.api.remoteservice.reward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.reward.RewardedActivityDto;
import cn.com.duiba.tuia.activity.center.api.dto.reward.RewardedActivityReq;
import cn.com.duiba.tuia.activity.center.api.dto.reward.config.RewardedActivityPrizeConfig;

import java.util.Map;

/**
 * 激励互动Remote服务接口
 *
 * @author zhangbaiqiang
 * @date 2019-07-14
 */
@AdvancedFeignClient
public interface RemoteRewardedActivityService {

    /**
     * 根据次数和活动判断出什么奖品
     *
     * @param req 请求参数
     * @return 奖品信息
     */
    RewardedActivityDto obtainPrize(RewardedActivityReq req);

    /**
     * 查询活动的激励互动奖励配置
     *
     * @param activityId 活动id
     * @return 激励互动奖励配置
     */
    RewardedActivityPrizeConfig queryPrizeConfig(Long activityId);

    /**
     * 更新活动的激励互动奖励配置
     *
     * @param activityId 活动id
     * @param config 激励互动配置
     * @return 更新后的激励互动配置
     */
    RewardedActivityPrizeConfig updatePrizeConfig(Long activityId, RewardedActivityPrizeConfig config);

    /**
     * 查询异常订单数量
     *
     * @return 媒体-异常订单数量映射
     */
    Map<Object, Object> queryErrorOrderCount();
}
