package cn.com.duiba.tuia.activity.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 屏蔽活动
 */
@Data
public class ActivityShieldingDTO implements Serializable {

    private static final long serialVersionUID = 8179896927143595122L;

    /**
     * tab栏类型 大盘推荐
     */
    public static final Integer TAB_TYPE_RECOMMEND = 4;

    /**
     * 屏蔽时间 永久屏蔽
     */
    public static final Integer DATE_TYPE_PERMANENT = 1;

    /**
     * 屏蔽时间 屏蔽一个月
     */
    public static final Integer DATE_TYPE_MONTH = 2;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * tab栏类型(1:活动库 2:我的收藏 3:热点活动 4:大盘推荐)
     */
    private Integer tabType;

    /**
     * 屏蔽时间(1:永久屏蔽 2:屏蔽一个月)
     */
    private Integer dateType;

    /**
     * 屏蔽开始时间
     */
    private Date startTime;

    /**
     * 屏蔽截止时间
     */
    private Date endTime;
}
