package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.PopularGroupDiDto;
import cn.com.duiba.tuia.activity.center.api.dto.ResourceIdeaDiDto;
import cn.com.duiba.tuia.activity.center.api.dto.ResourceLocationDiDto;
import cn.com.duiba.tuia.activity.center.api.dto.XunfeiDeviceStatisDto;

import java.util.List;

/**
 * @author weny.cai
 * @version 1.0
 * @description 讯飞
 * @date 2018/8/1 10:41
 **/
@AdvancedFeignClient
public interface RemoteXunfeiDeviceStatisService {

    /**
     * @description: 查询数据
     * @param curDate
     * @return List<XunfeiDeviceStatisDto>
     * @author weny.cai
     * @date 2018/8/1 10:44
     */
    List<XunfeiDeviceStatisDto> selectXunfeiDevice(String curDate,int offset, int max);

    /**
     * 推广组数据
     * @param startDate
     * @param endDate
     * @return
     */
    List<PopularGroupDiDto> selectGroupDataByDate(String startDate,String endDate);

    /**
     * 资源位数据
     * @param startDate
     * @param endDate
     * @return
     */
    List<ResourceLocationDiDto> selectResourceDataByDate(String startDate,String endDate);

    /**
     * 创意数据
     * @param startDate
     * @param endDate
     * @return
     */
    List<ResourceIdeaDiDto> selectIdeaDataByDate(String startDate, String endDate);

    List<ResourceIdeaDiDto> selectIdeaDiData(String startDate, String endDate, Integer putType);



    /**
     * 创意数据
     * @param deliveryGroupList 投放组
     * @param ideaIdList 创意集合
     * @param startDate 开始日期
     * @param endDate 结束日期
     * @return 报表统计
     */
    List<ResourceIdeaDiDto> selectIdeaDataByDateAndDeliveryGroup(List<Byte> deliveryGroupList, List<Long> ideaIdList, String startDate, String endDate);

}
