package cn.com.duiba.tuia.activity.center.api.dto.algo;

import cn.com.duiba.tuia.activity.center.api.dto.req.ReqPageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@ToString
@EqualsAndHashCode(callSuper = false)
public class ActivitySkinTitleReqDTO extends ReqPageQuery {

    private static final long serialVersionUID = -1813781093417287027L;

    /**
     * 1就是活动中的搜索
     */
    public static Integer ACTIVITY_SEARCH_FLAG = 1;

    /**
     * 标题id
     */
    private Long id;

    /**
     * 标题类别，
     */
    private Integer titleType;

    /**
     * 标题内容
     */
    private String titleContent;

    /**
     * 标题内容长度，string的数字，如6.5
     */
    private String titleContentLength;

    /**
     * 标题标签id
     */
    private Long titleTagId;


    /**
     * 标题标签名称
     */
    private String titleTagName;

    /**
     * 标题使用次数排序，默认1正序，0逆序
     */
    private Integer titleCountOrder;

    /**
     * 是否删除（是否上下线，默认0上线，1删除）
     */
    private Integer isDeleted;

    /**
     * 活动中的搜索：主标题、副标题两套逻辑---------------------
     * 主标题：文案限制规则；且排除已定向到其他皮肤的标题
     * 副标题：主标题标签关联可用的副标题；长度限制
     * <p>
     * titleType、titleContent也要
     * 【活动，主副】标题长度限制 titleContentLength
     */

    /**
     * 【活动，主副】默认0或Null，1走活动搜索
     */
    private Integer isActivitySearch;

    /**
     * 【活动，主】皮肤类型
     */
    private String skinType;

    /**
     * 【活动，副】主标题id
     */
    private Long titleFirstId;
    /**
     * 【活动，主标题】主标题是否定向皮肤
     */
    private Integer isOrientSkin;

    /**
     * 字符串裁剪次数
     */
    private Integer titleFontCutNum;

}

