package cn.com.duiba.tuia.activity.center.api.remoteservice.subtitle;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.subtitle.*;

import java.util.List;
import java.util.Map;

/**
 * 算法标题
 */
@AdvancedFeignClient
public interface RemoteSubAlgoService {

    /**
     * 获取开放广告位列表
     * @return 广告位Id集合
     */
    List<Long> getSubSlotList();
    /**
     * 广告位可投活动列表
     *
     **/
    List<SubActivityDTO> slotCanPutActivity(Long slotId);

    /** 广告位+活动列表
     * actIds 算法选出的10个活动
     * @return 可投奖品和k可投主标题
     **/
    SubPrizeTitleMaterielDTO listCanPutPrizeTitle(Long slotId, Long actId);

    /** 主副标题组合
     * mainTitleIds 主标题 20个
     * @return 主副标题组合
     **/
    Map<Long, List<SubTitleComposeDTO>> listCanPutComposeTitle(List<Long> mainTitleIds);

    /** 组件化组合
     * req subActivityList 10活动集合  prizeComposeList 10组奖品集合  titleComposeList 1组主副标题集合
     * 增加组合校验
     **/
    List<SubDTO> listSubPrizeTile(List<SubComposeReq> reqList);
}
