package cn.com.duiba.tuia.activity.center.api.remoteservice.commodity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.BasePair;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.commodity.CommercesGoodsDto;
import cn.com.duiba.tuia.activity.center.api.dto.commodity.CommercesGoodsQueryDto;

import java.util.List;

/**
 * @ClassName RemoteCommodityService
 * @Description 商品信息
 * @Author Zaizai
 * @Date 2020/7/10 3:25 下午
 **/
@AdvancedFeignClient
public interface RemoteCommercesGoodsService {

    /**
     * 获取单个商品详情信息
     * @param id
     * @return
     */
    CommercesGoodsDto selectById(String id);

    /**
     * 获取多个商品详情信息
     * @param ids
     * @return
     */
    List<CommercesGoodsDto> selectByIds(List<String> ids);

    /**
     * 新增/更新商品信息
     * @param commercesGoodsDto
     * @return
     */
    Boolean saveOrUpdateCommercesGoods(CommercesGoodsDto commercesGoodsDto);

    /**
     * 分页查询商品信息
     * @param commercesGoodsQueryDto
     * @return
     */
    PageDto<CommercesGoodsDto> selectByPage(CommercesGoodsQueryDto commercesGoodsQueryDto);

    /**
     * 强制根据id删除商品信息
     * @param id
     * @return
     */
    Boolean forceDeleteById(Long id);

    /**
     * 删除商品信息（存在业务校验）
     * @param id
     * @return BasePair<Boolean, String> Boolean 删除结果  String结果为false的原因
     */
    BasePair<Boolean, String> deleteById(Long id);
}
