package cn.com.duiba.tuia.activity.center.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.subtitle.SubActivityDTO;
import cn.com.duiba.tuia.activity.center.api.dto.subtitle.SubComposeDTO;
import cn.com.duiba.tuia.activity.center.api.dto.subtitle.SubDTO;
import cn.com.duiba.tuia.activity.center.api.dto.subtitle.SubPrizeTitleMaterielDTO;
import cn.com.duiba.tuia.activity.center.api.dto.tag.TagGroupCategoryDTO;
import cn.com.duiba.tuia.activity.center.api.dto.tag.TagGroupDTO;
import cn.com.duiba.tuia.activity.center.api.dto.tag.TagGroupRelationDTO;
import cn.com.duiba.tuia.activity.center.api.dto.tag.TuiaTagDTO;
import cn.com.duiba.tuia.activity.center.api.exception.ActivityCenterException;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;
import java.util.Map;

/**
 * 标签库
 * B端接口，C端请另起
 */
@AdvancedFeignClient
public interface RemoteTagService {

    /**
     * 根据标签组获取标签
     * @param groupIds 若为空则查询全部
     */
    List<TagGroupDTO> getTagByGroup(List<Long> groupIds);

    /**
     * 添加标签
     */
    void addTag(TuiaTagDTO dto) throws ActivityCenterException;

    /**
     * 删除标签
     * 校验标签是否仍在使用
     */
    void deleteTag(Long tagId) throws ActivityCenterException;

    /**
     * 添加标签组
     */
    void addTagGroup(TagGroupDTO dto) throws ActivityCenterException;

    /**
     * 标签组排序
     */
    void tagGroupSort(List<Long> tagGroupIds) throws ActivityCenterException;

    /**
     * 删除标签组
     * 校验标签组内标签是否在使用
     */
    void deleteTagGroup(Long tagGroupId) throws ActivityCenterException;

    /**
     * 查询标签组
     * @param name
     * @return
     */
    List<TagGroupDTO> getTagGroup4DropDown(String name);

    /**
     * 根据大类查询标签详情
     * @param categoryIds 不传则查全部
     * @return
     */
    List<TagGroupCategoryDTO> getCategoryGroupTag(List<Long> categoryIds);

    /**
     * 添加标签大类
     * @param req
     */
    void addCategory(TagGroupCategoryDTO req) throws ActivityCenterException;

    /**
     * 标签大类增加标签组
     * @param req
     */
    void categoryAddGroup(TagGroupRelationDTO req) throws ActivityCenterException;

    /**
     * 标签大类删除标签组
     * @param req
     */
    void categoryDelGroup(TagGroupRelationDTO req) throws ActivityCenterException;

    /**
     * 删除标签大类
     * @param categoryId
     */
    void deleteCategory(Long categoryId) throws ActivityCenterException;

    /**
     * 标签大类内标签组排序
     */
    void tagCategoryGroupSort(List<Long> tagGroupIds, Long categoryId) throws ActivityCenterException;
}
