package cn.com.duiba.tuia.activity.center.api.remoteservice.risk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.risk.*;

/**
 * 〈一句话功能简述〉<br>
 * Description: 风控：媒体审核相关接口
 *
 * @author hillchen
 * @create 2018/9/18 上午10:03
 */
@AdvancedFeignClient
public interface RemoteMediaAuditService {
    /**
     * 审核结果通知
     * @return
     */
    boolean auditResultNotic(AuditResult auditResult);

    /**
     * 分页查询活动审核列表
     *
     * @param req
     * @return
     */
    PageDto<AuditActivityInfo> selectAuditActivityToPage(ActivityAuditListReq req);


    /**
     * 查询流量引导页审核列表信息
     * @param req
     * @return
     */
    PageDto<AuditGuidePageConfigInfo> selectAuditGuidePageToPage(GuidePageAuditListReq req);


    /**
     * 查询插件工具审核列表信息
     * @param req
     * @return
     */
    PageDto<AuditPluginInfo> selectAuditPlugToPage(PlugAuditListReq req);


    /**
     * 查询活动审核列表总数,流量引导页审核列表信息数量,插件工具审核列表信息数量
     * @return
     */
    ActivityAuditPlatformRsp getActivityAuditCount();



}