package cn.com.duiba.tuia.activity.center.api.remoteservice.commodity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.BasePair;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.commodity.CommerceGoodsDto;
import cn.com.duiba.tuia.activity.center.api.dto.commodity.CommerceGoodsQueryDto;

import java.util.List;

/**
 * @ClassName RemoteCommerceGoodsService
 * @Description 商品信息
 * @Author Zaizai
 * @Date 2020/7/10 3:25 下午
 **/
@AdvancedFeignClient
public interface RemoteCommerceGoodsService {

    /**
     * 获取单个商品详情信息
     * @param id
     * @return
     */
    CommerceGoodsDto selectById(Long id);

    /**
     * 获取多个商品详情信息
     * @param ids
     * @return
     */
    List<CommerceGoodsDto> selectByIds(List<Long> ids);

    /**
     * 新增/更新商品信息
     * @param commerceGoodsDto
     * @return
     */
    Boolean saveOrUpdateCommerceGoods(CommerceGoodsDto commerceGoodsDto);

    /**
     * 分页查询商品信息
     * @param commerceGoodsQueryDto
     * @return
     */
    PageDto<CommerceGoodsDto> selectByPage(CommerceGoodsQueryDto commerceGoodsQueryDto);

    /**
     * 查询商品信息
     * @param commerceGoodsQueryDto
     * @return
     */
    List<CommerceGoodsDto> selectList(CommerceGoodsQueryDto commerceGoodsQueryDto);

    /**
     * 强制根据id删除商品信息
     * @param id
     * @return
     */
    Boolean forceDeleteById(Long id);

    /**
     * 删除商品信息（存在业务校验）
     * @param id
     * @return BasePair<Boolean, String> Boolean 删除结果  String结果为false的原因
     */
    BasePair<Boolean, String> deleteById(Long id);
}
