/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant.adx;

import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public enum XiaoEnAiSpecEnum {
    XIAO_EN_AI_001("001", "\u5f00\u5c4f", 20, "", "\u5f00\u5c4f", Arrays.asList(640), Arrays.asList(960), 1, 140, "jpg/jpeg/png", null, null),
    XIAO_EN_AI_002("002", "Banner", 21, "", "Banner", Arrays.asList(1536), Arrays.asList(440), 1, 140, "jpg/jpeg/png", null, null),
    XIAO_EN_AI_003("003", "\u4fe1\u606f\u6d41", 22, "1-4", "\u4e09\u56fe", Arrays.asList(300, 300, 300), Arrays.asList(300, 300, 300), 3, 140, "jpg/jpeg/png", 33, null),
    XIAO_EN_AI_004("003", "\u4fe1\u606f\u6d41", 23, "1-1", "\u5355\u56fe", Arrays.asList(960), Arrays.asList(640), 1, 140, "jpg/jpeg/png", 33, null),
    XIAO_EN_AI_005("003", "\u4fe1\u606f\u6d41", 24, "1-2", "\u56fe\u6587\u6458\u8981", Arrays.asList(960), Arrays.asList(640), 1, 140, "jpg/jpeg/png", 33, 33),
    XIAO_EN_AI_006("004", "\u8bc4\u8bba\u9875", 25, "", "\u4e09\u56fe\u8bc4\u8bba\u9875", Arrays.asList(960, 960, 960), Arrays.asList(640, 640, 640), 3, 140, "jpg/jpeg/png", 33, null),
    XIAO_EN_AI_007("004", "\u8bc4\u8bba\u9875", 26, "", "\u5355\u56fe\u8bc4\u8bba\u9875", Arrays.asList(960), Arrays.asList(640), 1, 140, "jpg/jpeg/png", 33, null);

    private String specCode;
    private String name;
    private Integer styleStandard;
    private String template;
    private String templateDescription;
    private List<Integer> picW;
    private List<Integer> picH;
    private Integer picNum;
    private Integer size;
    private String picType;
    private Integer titleLimit;
    private Integer contentLimit;

    private XiaoEnAiSpecEnum(String specCode, String name, Integer styleStandard, String template, String templateDescription, List<Integer> picW, List<Integer> picH, Integer picNum, Integer size, String picType, Integer titleLimit, Integer contentLimit) {
        this.specCode = specCode;
        this.name = name;
        this.styleStandard = styleStandard;
        this.template = template;
        this.templateDescription = templateDescription;
        this.picW = picW;
        this.picH = picH;
        this.picNum = picNum;
        this.size = size;
        this.picType = picType;
        this.titleLimit = titleLimit;
        this.contentLimit = contentLimit;
    }

    public String getName() {
        return this.name;
    }

    public Integer getStyleStandard() {
        return this.styleStandard;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public String getSpecCode() {
        return this.specCode;
    }

    public List<Integer> getPicW() {
        return this.picW;
    }

    public List<Integer> getPicH() {
        return this.picH;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getPicType() {
        return this.picType;
    }

    public Integer getTitleLimit() {
        return this.titleLimit;
    }

    public Integer getPicNum() {
        return this.picNum;
    }

    public Integer getContentLimit() {
        return this.contentLimit;
    }

    public static XiaoEnAiSpecEnum getEnumByStyleStandard(Integer styleStandard) {
        if (Objects.isNull(styleStandard)) {
            return null;
        }
        for (XiaoEnAiSpecEnum specEnum : XiaoEnAiSpecEnum.values()) {
            if (!Objects.equals(styleStandard, specEnum.getStyleStandard())) continue;
            return specEnum;
        }
        return null;
    }

    public static boolean isInfoFlow(ResourceIdeaDto ideaDto) {
        if (Objects.isNull(ideaDto) || Objects.isNull(ideaDto.getStyleStandard())) {
            return false;
        }
        XiaoEnAiSpecEnum specEnum = XiaoEnAiSpecEnum.getEnumByStyleStandard(ideaDto.getStyleStandard());
        return Objects.nonNull((Object)specEnum) && (specEnum == XIAO_EN_AI_003 || specEnum == XIAO_EN_AI_004 || specEnum == XIAO_EN_AI_005);
    }

    public static boolean isSummary(ResourceIdeaDto ideaDto) {
        if (Objects.isNull(ideaDto) || Objects.isNull(ideaDto.getStyleStandard())) {
            return false;
        }
        XiaoEnAiSpecEnum specEnum = XiaoEnAiSpecEnum.getEnumByStyleStandard(ideaDto.getStyleStandard());
        return Objects.nonNull((Object)specEnum) && specEnum == XIAO_EN_AI_005;
    }
}

