/**
 * Project Name:activity-center-api<br>
 * File Name:RemoteLandService.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.remoteservice<br>
 * Date:2017年3月24日上午10:29:26<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */
package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.CSVDto;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.LandButtonStaticDataDto;
import cn.com.duiba.tuia.activity.center.api.dto.LandDto;
import cn.com.duiba.tuia.activity.center.api.dto.LandInterfaceLogDto;
import cn.com.duiba.tuia.activity.center.api.dto.LandStaticDataDto;
import cn.com.duiba.tuia.activity.center.api.dto.LandUserInfoDto;
import cn.com.duiba.tuia.activity.center.api.dto.req.PageQueryLandReq;
import cn.com.duiba.tuia.activity.center.api.dto.req.ReqLandUserInfo;
import cn.com.duiba.tuia.activity.center.api.dto.rsp.AlipayCmapRsp;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * ClassName: RemoteLandService <br/>
 * Function: 落地页接口. <br/>
 * Reason: 落地页相关服务. <br/>
 * date: 2017年3月24日 上午10:29:26 <br/>
 *
 * @author wubo
 * @version 
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteLandService {
    
    /**
     * selectLandById:(查询落地页信息). <br/>
     * 客户端务必做缓存
     * @param id
     * @return
     */
    DubboResult<LandDto> selectLandById(Long id);
    
    /**
     * selectLandById:(查询落地页信息,不查缓存). <br/>
     * @param id
     * @return
     */
    LandDto selectLandByIdNoCache(Long id);

    /**
     * selectLandById:(用于代理商平台 查询落地页信息,不查缓存). <br/>
     * @param id
     */
    LandDto selectLandAgentByIdNoCache(Long id,Integer type);

    /**
     * saveLand:(保存落地页). <br/>
     * @param dto
     * @return
     */
    DubboResult<Long> saveLand(LandDto dto);
    
    /**
     * deleteLand:(删除落地页). <br/>
     * @param id
     * @return
     */
    DubboResult<Boolean> deleteLand(Long id);
    
    /**
     * selectLandList:(查询落地页). <br/>
     * @param id
     * @param title
     * @param offset
     * @param max
     * @return
     */
    DubboResult<PageDto<LandDto>> selectLandList(Long id,String title,Integer offset,Integer max);

    /**
     * selectLandList:(代理商平台 查询落地页). <br/>
     * @param id
     * @param title
     * @param offset
     * @param max
     * @return
             */
    DubboResult<PageDto<LandDto>> selectLandAgentList(Long id,String title,Integer type,Long advertiser,Integer offset,Integer max);

    /**
     * insertUserInfo:(添加用户信息). <br/>
     * @param dto
     * @return
     */
    DubboResult<Long> insertUserInfo(LandUserInfoDto dto);
    
    /**
     * selectUserPhoneExist:(查询手机号是否存在). <br/>
     * @param userPhone
     * @param landId
     * @return
     */
    DubboResult<Boolean> selectUserPhoneExist(String userPhone,Long landId);
    
    /**
     * selectIdentificationExist:(查询身份证号是否存在). <br/>
     * @param identification
     * @param landId
     * @return
     */
    DubboResult<Boolean> selectIdentificationExist(String identification,Long landId);
    
    /**
     * 
     * insertLandInterfaceLog:(落地页日志插入). <br/>
     * @return
     */
    DubboResult<Boolean> insertLandInterfaceLog(LandInterfaceLogDto dto);
    
    /**
     * updateUserInfo:(更新用户信息). <br/>
     * @param dto
     * @return
     */
    DubboResult<Boolean> updateUserInfo(LandUserInfoDto dto);
    
    /**
     * selectUserInfoCount:(查询用户信息数量). <br/>
     * @param landId
     * @param start
     * @param end
     * @return
     */
    DubboResult<Integer> selectUserInfoCount(Long landId,Date start,Date end);
    
    /**
     * selectUserInfoList:(查询用户信息). <br/>
     * @param landId
     * @param start
     * @param end
     * @param offset
     * @param max
     * @return
     */
    DubboResult<List<LandUserInfoDto>> selectUserInfoList(Long landId,Date start,Date end,Integer offset,Integer max);

    List<LandUserInfoDto> queryLandUserInfoList(List<Long> landIds, Date start, Date end, Integer offset, Integer max);

    List<LandUserInfoDto> queryLandUserInfoListByAdvertIds(List<Long> advertIds, Date start, Date end, Integer offset, Integer max);



    /**
     * downloadUserInfo:(查询用户信息 csv格式). <br/>
     * @param landId
     * @param start
     * @param end
     * @param currentPage
     * @param switches
     * @return
     */
    DubboResult<CSVDto> downloadUserInfo(Long landId,Date start,Date end,Integer currentPage,Integer switches);

    AlipayCmapRsp drawcmapTrigger(LandUserInfoDto landUserInfoDto);

    /**
     * 支付宝线下活动红包
     * @param landUserInfoDto
     * @param type duiba/tuia
     * @return
     */
    AlipayCmapRsp drawcmapTriggerNew(LandUserInfoDto landUserInfoDto, String type);

    /**
     * 积木平台分页查询落地页接口
     */
    PageDto<LandDto> selectLandListByAdvertOrAe(PageQueryLandReq req);

    /**
     * 积木平台根据落地页id查询落地页
     */
    LandDto getLandById(Long landId);

    /**
     * 校验 身份证 手机号码 邮箱 在同一个落地页数据中是否有重复的
     */
    Map<String,Boolean> checkUniqueness(LandUserInfoDto dto);

    /**
     * 根据落地页id和时间查询表单信息
     */
    List<LandUserInfoDto> selectLandUserInfo(String landId, String start, String end);

    /**
     * 根据落地页id和时间查询落地页统计数据
     */
    List<LandStaticDataDto> landStaticData(String landId, String start, String end);

    /**
     * 根据积木建站落地页id 起始时间 查询落地页中按钮的点击pv
     * @param landId 落地页id
     * @param startDate 开始时间
     * @param endDate 结束时间
     * @return
     */
    List<LandButtonStaticDataDto> landButtonStaticData(String landId, String startDate, String endDate);

    /**
     * 根据落地页id批量获取落地页
     *
     * @param ids 落地页id集合
     * @return
     */
    List<LandDto> selectLandPageByIds(List<Long> ids);

    /**
     * 这里根据查询参数查处当前用户可以看到的所有的落地页ID(分页参数无用)
     *
     * @param req 查询参数
     * @return
     */
    List<Long> selectLandIdListByAdvertOrAe(PageQueryLandReq req);

    /**
     * 根据id集合批量查询(跟上面相比新增了一个thumbnail_url字段)
     *
     * @param list
     * @return
     */
    List<LandDto> selectLandByIdsExt(List<Long> list);

    /**
     * 积木查询
     * @param req
     * @return
     */
    List<LandDto> selectLandListByPageQueryLandReq(PageQueryLandReq req);

    /**
     * 表单提交数据查询 by req
     *
     * @param info
     * @return
     */
    List<LandUserInfoDto> selectLandUserInfoByReq(ReqLandUserInfo info);

    /**
     * JF建站平台分页查询
     * @param req
     * @return
     */
    PageDto<LandDto> selectPageForJfSite(PageQueryLandReq req);

    /**
     * JF建站平台 根据ID查询落地页
     * @param landId
     * @return
     */
    LandDto getLandByIdForJfSite(Long landId);

}
