package cn.com.duiba.tuia.activity.center.api.bean.dto;

import org.apache.commons.lang.StringUtils;

import java.math.BigDecimal;

/**
 * 〈一句话功能简述〉<br>
 * Description: adx报表数据统计
 *
 * @author xierongli
 * @create 2019-06-18 10:41
 */
public class AdxReport {
    /**
     * 曝光数
     */
    private Integer exposureNumber = 0;
    /**
     * 点击数
     */
    private Integer clickNumber = 0;
    /**
     * 点击率
     */
    private Double clickRate = 0.0d;
    /**
     * 消耗
     */
    private Double cost =0.0d;
    /**
     * 平均出价
     */
    private Double averageBid =0.0d;
    /**
     * 点击价值
     */
    private Double cpc = 0.0d;

    /**
     *  统计曝光，点击，消耗总数
     * @param exposureNumber 曝光数
     * @param clickNumber 点击数
     * @param price 消耗
     * @param adxReport 封装的对象
     */
    public static  void convert(Integer exposureNumber, Integer clickNumber, String  price, AdxReport adxReport){
        if(adxReport != null && adxReport.getExposureNumber() != null){
            adxReport.setExposureNumber(adxReport.getExposureNumber() + exposureNumber);
        }
        if(adxReport != null && adxReport.getClickNumber() != null){
            adxReport.setClickNumber(adxReport.getClickNumber() + clickNumber);
        }
        if(adxReport != null && StringUtils.isNotBlank(price)){
            BigDecimal oldValue = new BigDecimal(adxReport.getCost().toString());
            BigDecimal newValue = new BigDecimal(price);
            adxReport.setCost(oldValue.add(newValue).setScale(3, BigDecimal.ROUND_HALF_UP).doubleValue());
        }
    }


    /**
     * 计算adx点击率，平均出价，点击价值
     * @param adxReport
     */
    public static void compute(AdxReport adxReport){
        if(adxReport != null && adxReport.getExposureNumber() != null && adxReport.getClickNumber() != null
                && adxReport.getClickNumber() != 0 && adxReport.getExposureNumber() != 0){
            BigDecimal exposureNumber = new BigDecimal(adxReport.getExposureNumber().toString());
            BigDecimal clickNumber = new BigDecimal(adxReport.getClickNumber().toString());
            BigDecimal hundred = BigDecimal.TEN.multiply(BigDecimal.TEN);
            //点击率
            adxReport.setClickRate(clickNumber.divide(exposureNumber, 4, BigDecimal.ROUND_HALF_UP).multiply(hundred).setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue());
            //平均出价
            BigDecimal cost = new BigDecimal(adxReport.getCost().toString());
            adxReport.setAverageBid(cost.divide(exposureNumber, 6, BigDecimal.ROUND_HALF_UP).multiply(BigDecimal.TEN.multiply(hundred)).setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue());
            //点击价值
            adxReport.setCpc(cost.divide(clickNumber,2, BigDecimal.ROUND_HALF_UP).doubleValue());
        }
    }

    public Integer getExposureNumber() {
        return exposureNumber;
    }

    public void setExposureNumber(Integer exposureNumber) {
        this.exposureNumber = exposureNumber;
    }

    public Integer getClickNumber() {
        return clickNumber;
    }

    public void setClickNumber(Integer clickNumber) {
        this.clickNumber = clickNumber;
    }

    public Double getClickRate() {
        return clickRate;
    }

    public void setClickRate(Double clickRate) {
        this.clickRate = clickRate;
    }

    public Double getCost() {
        return cost;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }

    public Double getAverageBid() {
        return averageBid;
    }

    public void setAverageBid(Double averageBid) {
        this.averageBid = averageBid;
    }

    public Double getCpc() {
        return cpc;
    }

    public void setCpc(Double cpc) {
        this.cpc = cpc;
    }
}
