package cn.com.duiba.tuia.activity.center.api.common;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/**
 * Created by guoyanfei .
 * 2021/7/21 .
 */
public class DateUtils {

    private static final SimpleDateFormat  YEAR    = getFormat("yyyy");
    private static final DateTimeFormatter DF_YEAR = DateTimeFormatter.ofPattern("yyyy");

    private static final ZoneId zoneId = ZoneId.systemDefault();

    private static String getStr(Date date, SimpleDateFormat format) {
        if (date == null) {
            return "";
        }
        return format.format(date);
    }

    private static SimpleDateFormat getFormat(String format) {
        return new SimpleDateFormat(format);
    }

    private static LocalDateTime date2LocalDateTime(Date date) {
        Instant instant = date.toInstant();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public static String getYearStr3(LocalDateTime localDateTime) {
        return localDateTime.format(DF_YEAR);
    }

    /**
     * method : 1、根据Date类型获取"yyyy"字符串
     */
    public static String getYearStr2(Date date) {
        return date2LocalDateTime(date).format(DF_YEAR);
    }

    /**
     * method : 1、根据Date类型获取"yyyy"字符串
     */
    public static String getYearStr(Date date) {
        synchronized (YEAR) {
            return getStr(date, YEAR);
        }
    }

    public static void main(String[] args) {
        ExecutorService es = Executors.newFixedThreadPool(1000);

        for (int j = 0; j < 10; j++) {
            List<Future> fs = new ArrayList<>(1000);
            long start = System.currentTimeMillis();
            for (int i = 0; i < 5000000; i++) {
                fs.add(es.submit(() -> {
                    Date now = new Date();
                    getYearStr(now);

//                        LocalDateTime localDateTime = LocalDateTime.now();
//                        getYearStr3(localDateTime);
                }));
            }
            for (Future f : fs) {
                try {
                    f.get();
                } catch (InterruptedException e) {
                    e.printStackTrace();
                } catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            long end = System.currentTimeMillis();
            System.out.println("消耗时间： " + (end - start));
        }

        es.shutdown();

    }

}
