package cn.com.duiba.tuia.activity.center.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.tag.*;
import cn.com.duiba.tuia.activity.center.api.exception.ActivityCenterException;

import java.util.List;
import java.util.Set;


@AdvancedFeignClient
public interface RemoteTagMappingService {

    /**
     * 添加标签大类
     *
     * @param req
     */
    void addCategory(TagMappingCategoryDTO req) throws ActivityCenterException;

    /**
     * 添加标签组
     */
    void addTagMapping(TagMappingDTO dto) throws ActivityCenterException;


    Long addTagMappingReturnId(TagMappingDTO dto) throws ActivityCenterException;


    void categoryAddMapping(TagMappingRelationDTO req) throws ActivityCenterException;

    void addTags(TuiaTagAddMappingDTO dto) throws ActivityCenterException;

    void deleteTag(Long tagId, Long mappingId);

    List<TagMappingCategoryDTO> getCategoryMappingTag(List<Long> categoryIds);

    List<TagMappingDTO> getTagByMapping(List<Long> mappingIds);

    List<String> queryDomainPuScene(List<Long> tagIds);

    Set<Long> getDomainMappingsByTagIds(List<Long> tagIds);
}
