package cn.com.duiba.tuia.activity.center.api.dto;

import cn.com.duiba.tuia.activity.center.api.dto.req.ReqPageQuery;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

/**
 * 落地页模板表
 * @author lijicong
 * @since 2021-07-08
 */
@Getter
@Setter
public class LandTemplateQueryDTO extends ReqPageQuery {

    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("落地页名称")
    private String title;

    @ApiModelProperty("1:删除，0:未删除")
    private Boolean isDeleted = false;

    @ApiModelProperty("创建时间开始")
    private Date gmtCreateStart;

    @ApiModelProperty("创建时间结束")
    private Date gmtCreateEnd;

    @ApiModelProperty("网页名称")
    private String webName;

    @ApiModelProperty("sso系统用户id")
    private Long ssoAeId;

    @ApiModelProperty(value = "落地页标签，多个逗号隔开")
    private String promoteTag;

}