package cn.com.duiba.tuia.activity.center.api.dto.adx;

import cn.com.duiba.tuia.activity.center.api.bean.enums.adx.IdeaBidTypeEnum;
import cn.com.duiba.tuia.activity.center.api.constant.adx.AdxIdeaAuditStatus;
import cn.com.duiba.tuia.activity.center.api.constant.adx.IdeaStyleStandardEnum;
import cn.com.duiba.tuia.activity.center.api.constant.adx.UnitPutTypeEnum;
import cn.com.duiba.tuia.activity.center.api.dto.adx.unit.MaterialUnitDTO;
import cn.com.duiba.tuia.activity.center.api.dto.creative.IdeaVideoDto;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 创意
 *
 * @author weny.cai
 * @date 2018/12/3 14:27
 **/
@Data
@ToString
public class ResourceIdeaDto implements Serializable {

    private static final long serialVersionUID = 2078063159077522207L;
    private Long id;

    private Long resourceId;

    private String ideaName;

    /** 是否开启预发券：0. 未开启 1. 已开启 **/
    private Integer preLoadAdvertStatus;

    private Integer switchState;

    private Long slotId;

    private String ideaTitle;

    private String ideaDesc;

    private String buttonText;

    private String iconUrl;

    private String picUrl;

    private Integer directType;

    private Integer budgetType;

    private Double dayBudget;

    private String dayBudgetStr;

    /**
     * 出价（元/CPM）
     */
    private Double ideaPrice;

    /**
     * 出价（元/CPM）
     */
    private String ideaPriceStr;

    private Integer seqNum;

    private Integer iconH;

    private Integer iconW;

    private Integer picH;

    private Integer picW;

    private String resourceName;

    private String groupName;

    private Long groupId;

    private Integer adxType;

    /** 是否走新的ADX架构标识符 **/
    private boolean upgrade;

    private Integer sysState;

    private List<String> sysValue;

    private Date gmtCreate;

    private Date gmtModified;

    private ResourceLocationDto resourceLocationDto;

    private List<IdeaPictureDto> ideaPictureDtos;

    /*
     * 创意视频
     */
    private IdeaVideoDto ideaVideo;

    /**
     * 规格样式
     * {@link IdeaStyleStandardEnum}
     */
    private Integer styleStandard;

    private Integer exposurePv;

    private Integer clickPv;

    /**
     * 消耗
     */
    private String price;

    private String clickRate;

    /**
     * 点击率显示文本
     */
    private String ctrText;

    /**
     * 平均扣费
     */
    private String agvPrice;

    private String cpcPrice;

    /**
     * 出价类型类型 0-- 人工出价 1--算法出价
     */
    private Integer priceType;

    /**
     * 最低 ROI
     */
    private Double minRoi;

    /**
     * 最小创意出价：包含
     */
    private Double minPrice;

    /**
     * 最大创意出价：包含
     */
    private Double maxPrice;

    private Integer timesLimitFlag;

    private Integer timesLimitType;

    private Integer limitNum;

    /**
     * 审核状态 {@link AdxIdeaAuditStatus}
     */
    private Integer auditStatus;

    /**
     * 审核理由
     */
    private String auditReason;

    /**
     * 失效时间
     */
    private Date expireTime;

    /**
     * 创意审核状态
     */
    private List<ResourceIdeaAuditDto> resourceIdeaAuditDtoList;
    /**
     * 可投资源位列表
     */
    private List<ShortResourceLocationDto> enableResourceLocations;


    /** 投放地域（0：不限，1：自定义）默认0 */
    private Integer putAreaType;

    /** 区域码（多个以逗号拼接） */
    private String areaCode;

    /** 广告位样式ID **/
    private Long adStyleId;

    /** 广告位样式模版ID **/
    private String templateId;

    private String styleName;

    /** 地域码集合 */
    private List<Long> areaCodeList;

    /**
     * 创意竞价类型：0:互动 1：直投 {@link IdeaBidTypeEnum#code}
     */
    private Integer             bidType;

    /**
     * 创意绑定的广告计划id
     */
    private Long                advertId;

    /**
     * PMP投放类型，0:RTB，1:PD，2:PDB
     *
     * @see cn.com.duiba.tuia.activity.center.api.constant.adx.PmpType
     */
    private Integer pmpType;

    private Double roi;

    /**
     * 每PV发券开关 0-关 1-开
     */
    private Integer pvLaunchFlag;

    /**
     * 每PV发券阈值
     */
    private Double pvLaunchLimit;

    /**
     * 创意出价策略(只在查询单个创意的时候返回，列表的时候注意为空)
     */
    private IdeaPriceStrategyDTO ideaPriceStrategyDTO;

    /**
     * 频次等级：1.强 2.中 3.弱
     */
    private Integer frequencyLevel;

    /**
     * 是否开启DeepLink：0.关闭 1.开启
     */
    private Integer disabledDeepLink;

    /**
     * 每PV点券开关 0-关 1-开
     */
    private Integer pvClickFlag;

    /**
     * 每PV点券阈值
     */
    private Double pvClickLimit;

    /**
     *  是否开启dpa,0:不开启 1：开启
     */
    private Integer dpaFlag;

    /**
     * 素材url，仅给前端展示使用
     */
    private String materialUrl;

    private List<ResourceIdeaCrowdBindDto> orientationCrowds;

    private Set<Integer> orientationCrowdTypes;

    private List<ResourceIdeaCrowdBindDto> excludeCrowds;

    private Set<Integer> excludeCrowdTypes;

    private Set<Integer> crowdTypes;

    private Integer crowdBindType;

    private Integer crowdBindLogicType;

    /**
     * pd预算类型
     */
    private Integer pdbBudgetType;

    /**
     * pd每日预算
     */
    private Double pdbDayBudget;

    /**
     * pd出价类型
     */
    private Integer pdbPriceType;

    /**
     * 是否新架构4.0 0/null-否 1-是
     */
    private Integer isNew;

    /**
     * 创意素材投放方式 1-人工 2-算法
     * @see UnitPutTypeEnum
     */
    private Integer unitPutType;

    /**
     * 创意素材ID展示明细
     */
    private List<MaterialUnitDTO> materialUnitDTOList;

    /**
     * 创意计划多样式
     */
    private List<Long> adStyleIdList;

    /**
     * 投放时间-开始
     */
    private String startDate;

    /**
     * 投放时间-截止
     */
    private String endDate;

    /**
     * 投放时间段
     */
    private String timePeriod;

    /**
     * 投放时间段
     */
    private List<ResourceTimeDto> timeDtos;

    /**
     * 平均扣费
     */
    private String ideaAvgPriceStr;

    /**
     * 资源计划标签对象集合
     */
    private List<ResourceIdeaTagRelationDto> tagRelationData;

    /**
     * 创意计划投放比例
     */
    private Integer deliveryRatio;

    /**
     * 投放管理开关：0.关闭；1.开启
     */
    private Integer deliveryManageSwitch;

    /**
     * 创意名称通配符
     */
    private String ideaNameWildcard;
}

