package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.MarsUserDto;

/**
 * [优酷火星情报局]接口
 *
 * @author zhangbaiqiang
 * @date 2018/10/14
 */
@AdvancedFeignClient
public interface RemoteMarsService {

    /**
     * 通过设备id获取用户信息
     *
     * @param deviceId 设备id
     * @param consumerId 用户id
     * @return 用户信息
     */
    MarsUserDto selectUser(String deviceId, Long consumerId);

    /**
     * 用户审核提案
     *
     * @param deviceId
     */
    void audit(String deviceId);

    /**
     * 用户分享提案
     *
     * @param deviceId 设备id
     */
    void share(String deviceId);

    /**
     * 用户领取分享奖励
     *
     * @param deviceId 设备id
     */
    void shareReward(String deviceId);

    /**
     * 用户领取升级红包
     *
     * @param deviceId 设备id
     */
    void upgradeReward(String deviceId);
}
