package cn.com.duiba.tuia.activity.center.api.constant.adx;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * 创意pk类型
 *
 * @author peanut.huang
 * @date 2020/1/13 17:47
 */
public enum IdeaPKTypeEnum {


    /**
     *
     */
    PRICE(1,"按价格高者胜出胜出"),

    PROFIT(2,"按收益高者胜出")

    ;

    /**
     * 类型
     */
    @Getter
    private int type;

    /**
     * 描述
     */
    @Getter
    private String desc;

    IdeaPKTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    /**
     * 根据类型值获取pk类型
     *
     * @param type
     * @return
     */
    public static IdeaPKTypeEnum findByType(int type){
        return Stream.of(IdeaPKTypeEnum.values()).filter(e -> e.getType() == type).findFirst().orElse(null);
    }

}
