package cn.com.duiba.tuia.activity.center.api.remoteservice.adx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.bean.dto.SlotDTO;
import cn.com.duiba.tuia.activity.center.api.bean.dto.SlotDisplayDTO;
import cn.com.duiba.tuia.activity.center.api.bean.iqiyi.AdType;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.constant.adx.AdxTypeEnum;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceLocationDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourcePicSpecificationDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.SlotStyleDto;
import cn.com.duiba.tuia.activity.center.api.dto.crowd.CrowdDataDTO;
import cn.com.duiba.tuia.activity.center.api.dto.req.ResourceLocationPageReq;

import java.util.List;

/**
 * 资源位
 *
 * @author weny.cai
 * @date 2018/11/30 10:50
 **/
@AdvancedFeignClient
public interface RemoteResourceLocationService {

    boolean add(ResourceLocationDto resourceLocationDto) throws BizException;

    boolean judgeSameSlot(Integer adxType, List<String> posIds, List<String> posIdList);

    boolean update(ResourceLocationDto resourceLocationDto) throws BizException;

    String batchEdit(ResourceLocationDto resourceLocationDto) throws BizException;

    ResourceLocationDto getResourceLocationDto(Long id);
    ResourceLocationDto getResourceLocationForAdx(Long id);

    PageDto<ResourceLocationDto> pageQuery(ResourceLocationPageReq req);

    PageDto<ResourceLocationDto> specificSortPageQuery(ResourceLocationPageReq req);

    List<ResourceLocationDto> getAll();

    boolean changeSwitchStateById(Long id, Integer switchState);

    boolean batchChangeSwitchStateById(List<Long> idList, Integer switchState) throws BizException;

    List<ResourcePicSpecificationDto> getResourceSpecById(Long resourceId);

    boolean isExistPic(Long specId) throws BizException;

    boolean savePutType(Long sourceId, Integer putType);

    ResourceLocationDto getResourceByTagId(String tagId);

    /**
     * 根据媒体广告位id 和 adx类型查询资源位
     *
     * @param tagId    媒体广告位id
     * @param adxType  隶属于哪个adx {@link AdxTypeEnum#getType()}
     * @return
     */
    ResourceLocationDto getResourceByTagIdAndAdxType(String tagId, Integer adxType);

    Long getGroupIdByResourceId(Long resourceId);

    void deleteById(Long id) throws BizException;

    /**
     * 批量删除资源位
     * @param ids
     * @return
     * @throws BizException
     */
    String batchDeleteByIds(List<Long> ids) throws BizException;

    /**
     * 根据资源位Id查询关联第三方的广告位标识
     *
     * @param resourceLocationId 资源位Id
     * @return 返回集合
     */
    List<String> queryPosIdsById(Long resourceLocationId);

    /**
     * 根据第三方广告位Ids查询
     *
     * @param impIds
     * @return 返回推啊广告位Ids
     */
    List<String> getResourceIdsByImpIds(List<String> impIds);

    /**
     * 根据adxType查询广告位
     *
     * @param adxType
     * @return 广告位集合
     */
    List<SlotDTO> queryAllSlot(Integer adxType);

    /**
     * 根据第三方广告位Id查询广告样式
     *
     * @param slotId  广告位Id
     * @param adxType adx
     * @return 广告样式集合
     */
    List<SlotDisplayDTO> getSlotDisplayStyle(Integer adxType, String slotId);

    /**
     * 查询广告类型
     * <p>需要用到该接口的adx参考{@link cn.com.duiba.tuia.activity.center.api.constant.adx.AdxTypeEnum}中storeType=2定义的adx</p>
     *
     * @param adxType
     * @return
     */
    List<SlotStyleDto> getSlotStyle(Integer adxType);

    /**
     * 根据资源位主键获取资源位简化模型
     *
     * @param resourceLocationId 资源位Id
     * @return 资源位模型
     */
    ResourceLocationDto getSimpleResourceLocation(Long resourceLocationId);

    /**
     * 根据资源位规格,adx类型,媒体Id查询资源位
     *
     * @param specCodeList 资源位规格集合
     * @param adxType      adx类型
     * @param mediaId      媒体Id
     * @return 资源位列表
     */
    List<ResourceLocationDto> queryForList(List<String> specCodeList, Integer adxType, Long mediaId);


    /**
     * 根据adxType生成广告类型
     *
     * @param adxType 广告类型
     * @return 广告类型集合
     */
    List<AdType> getAdType(Integer adxType);



    /**
     * 功能描述 根据广告位类型ID查询资源位是否存在
     * @author shenjiaqing
     * @date 13:54 2019/11/19
     * @param [adTypeId]
     * @return java.lang.Integer
     **/
    Integer resourceLocationIsExistsByAdTypeId(Long adTypeId);

    /** 条件查询资源位列表
     * 功能描述
     * @author shenjiaqing
     * @date 11:12 2020/5/12
     * @param [req]
     * @return java.util.List<cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceLocationDto>
     **/
    List<ResourceLocationDto> getResourceListByCondition(ResourceLocationPageReq req);

    List<CrowdDataDTO> crowdsList();

    List<CrowdDataDTO> searchList(String word);

    /**
     * 查询所有在投的资源位列表
     * @return
     */
    List<ResourceLocationDto> getAllValid();

}
