package cn.com.duiba.tuia.activity.center.api.remoteservice.adx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.IdeaPictureDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaCombDTO;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.UpdatePreLoadAdvertDto;
import cn.com.duiba.tuia.activity.center.api.dto.req.IdeaSortReq;
import cn.com.duiba.tuia.activity.center.api.dto.req.ResourceIdeaPageReq;
import cn.com.duiba.tuia.activity.center.api.dto.req.ResourceIdeaQueryReq;
import cn.com.duiba.tuia.activity.center.api.dto.req.ResourceIdeaReq;
import cn.com.duiba.tuia.activity.center.api.dto.rsp.ResourceIdeaThreeRsp;

import java.util.List;

/**
 * 创意服务
 *
 * @author weny.cai
 * @date 2018/12/3 14:26
 **/
@AdvancedFeignClient
public interface RemoteResourceIdeaService {

    boolean add(ResourceIdeaDto dto) throws BizException;

    boolean addV4(ResourceIdeaCombDTO dto) throws BizException;

    boolean update(ResourceIdeaDto dto) throws BizException;

    boolean updateV4(ResourceIdeaCombDTO dto) throws BizException;

    String batchUpdateV4(List<ResourceIdeaCombDTO> resourceIdeaCombDTOList);

    PageDto<ResourceIdeaDto> pageQuery(ResourceIdeaPageReq req);

    List<ResourceIdeaDto> queryListByResourceId(Long resourceId);

    List<ResourceIdeaDto> queryListByResourceIdAndPmpType(Long resourceId, Integer pmpType);

    Boolean sortIdea(IdeaSortReq req) throws BizException;

    ResourceIdeaDto getIdeaById(Long id);

    boolean changeSwitchStateById(Long id, Integer switchState);

    String batchChangeSwitchState(List<Long> idList, Integer switchState);

    List<IdeaPictureDto> getPictureByIdeaId(Long ideaId);

    /**
     * 手动触发获取审核状态
     *
     * @param ideaId
     */
    void manualObtianAuditStatus(Long ideaId);

    void deleteById(Long id) throws BizException;

    String batchDelete(List<Long> idList);

    /**
     * 获取adx广告位id
     *
     * @return
     */
    List<Long> selelctAdxSlotIds();

    /**
     * 根据switchStatus查询创意
     *
     * @param switchStatus switchStatus
     * @return list
     */
    List<ResourceIdeaDto> queryAllIdeaBySwitchStatus(Integer switchStatus);

    /**
     * 根据创意Id查询审核记录
     *
     * @param ideaId
     * @return
     */
    List<ResourceIdeaThreeRsp> queryForResourceIdeaAuditList(Long ideaId);

    /**
     * 根据条件查询创意集合
     *
     * @param req
     * @return
     */
    List<Long> selectIds(ResourceIdeaPageReq req);

    /**
     * 根据创意ID查询创意详情（不会关联其他表数据）
     *
     * @param ideaId
     * @return
     */
    ResourceIdeaDto queryIdeaById(Long ideaId);

    /**
     * 根据创意Id查询创意(组合返回图片和推广组信息)
     * @param ideaId
     * @return
     */
    ResourceIdeaDto getIdeaWithPictureAndGroup(Long ideaId);

    /**
     * 查询可用的算法出价的创意
     *
     * @return list
     */
    List<ResourceIdeaDto> queryAlgoIdeaBySwitchStatus();

    List<ResourceIdeaDto> getAlgIdeaBySwitchStatus();

    /**
     * 查询可用的算法出价的创意
     *
     * @return list
     */
    List<ResourceIdeaDto> queryAlgoIdeaBySwitchStatusV4();

    /**
     * 查询可用的PD创意
     *
     * @return list
     */
    List<ResourceIdeaDto> queryPdIdeaBySwitchStatus();

    /**
     * 功能描述 根据广告位样式ID集合查询资源创意是否存在
     * @author shenjiaqing
     * @date 11:36 2019/11/20
     * @param [adStyleIdList]
     * @return java.lang.Integer
     **/
    Integer resourceIdeaIsExistsByAdStyleId(List<Long> adStyleIdList);


    /**
     * 根据资源位Id与操作系统名称查询有效创意
     * @param resourceLocationId 资源位Id
     * @param osName 操作系统（Android,iOS,其他）
     * @return 有效创意的集合
     */
    List<ResourceIdeaDto> finaValidIdeas(Long resourceLocationId, String osName);

    /**
     * 根据资源位Id与操作系统名称查询有效创意
     * @param resourceLocationId 资源位Id
     * @param osName 操作系统（Android,iOS,其他）
     * @param pmpType pmp交易类型
     * @see cn.com.duiba.tuia.activity.center.api.constant.adx.PmpType
     * @return 有效创意的集合
     */
    List<ResourceIdeaDto> finaValidIdeasByPmpType(Long resourceLocationId, String osName, Integer pmpType);

    /**
     * 功能描述
     * @author shenjiaqing
     * @date 19:36 2019/12/23
     * @param [ideaId]
     * @return ResourceIdeaThreePartyAudit
     **/
    String selectByIdeaId(Long ideaId);

    /**
     * 功能描述 开启预发券功能
     * @author shenjiaqing
     * @date 13:51 2019/12/30
     * @param dto
     * @return boolean
     **/
    boolean updatePreLoadAdvertStatus(UpdatePreLoadAdvertDto dto);

    /**
     * @Description  查询所有直投广告位ID
     * @Date 19:59 2020-04-10
     * @Param []
     * @return java.util.List<java.lang.Long>
     **/
    List<Long> getAllDirectSlotIds();

    List<ResourceIdeaDto> queryIdeaList(ResourceIdeaQueryReq req);

    PageDto<ResourceIdeaDto> specificSortPageQuery(ResourceIdeaPageReq req);

    List<ResourceIdeaDto> queryIdeaListByIdeaIds(List<Long> ideaIds);

    List<ResourceIdeaDto> getValidIdeas(ResourceIdeaQueryReq req);

    List<ResourceIdeaDto> selectIdeaListByDeliveryManageSwitch(Long resourceLocationId, Integer deliveryManageSwitch);

    /**
     * 通过id更新创意名称
     * @param id
     * @param ideaName
     * @param ideNameWildcard
     * @return
     */
    Boolean modifyIdeaNameById(Long id, String ideaName, String ideNameWildcard);

}
