/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum AppFlowTypeEnum {
    WECHAT("1", "micromessenger", "\u5fae\u4fe1"),
    QQ("2", "qq", "QQ"),
    ALIPAY("3", "alipayclient", "\u652f\u4ed8\u5b9d"),
    OTHER("4", "", "\u5176\u4ed6"),
    WECHAT_PROGRAM("5", "miniprogram", "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f"),
    ALIPAY_PROGRAM("6", "miniprogram", "\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f");

    private String code;
    private String uaFlag;
    private String desc;
    private static Map<String, AppFlowTypeEnum> enumMap;

    private AppFlowTypeEnum(String code, String uaFlag, String desc) {
        this.code = code;
        this.uaFlag = uaFlag;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getUaFlag() {
        return this.uaFlag;
    }

    public String getDesc() {
        return this.desc;
    }

    public static AppFlowTypeEnum getByName(String code) {
        AppFlowTypeEnum appFlowTypeEnum = enumMap.get(code);
        return appFlowTypeEnum == null ? OTHER : appFlowTypeEnum;
    }

    public static AppFlowTypeEnum findByUserAgent(String userAgent) {
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            return OTHER;
        }
        String toLowerCase = userAgent.toLowerCase();
        if (toLowerCase.contains(WECHAT.getUaFlag())) {
            if (toLowerCase.contains(WECHAT_PROGRAM.getUaFlag())) {
                return WECHAT_PROGRAM;
            }
            return WECHAT;
        }
        if (toLowerCase.contains(QQ.getUaFlag())) {
            return QQ;
        }
        if (toLowerCase.contains(ALIPAY.getUaFlag())) {
            if (toLowerCase.contains(ALIPAY_PROGRAM.getUaFlag())) {
                return ALIPAY_PROGRAM;
            }
            return ALIPAY;
        }
        return OTHER;
    }

    static {
        enumMap = Maps.newHashMap();
        for (AppFlowTypeEnum item : AppFlowTypeEnum.values()) {
            enumMap.put(item.getCode(), item);
        }
    }
}

