package cn.com.duiba.tuia.activity.center.api.util;

import org.apache.http.client.HttpClient;
import org.apache.http.client.config.CookieSpecs;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

/**
 * @author: tangzhen@duiba.com.cn
 * @date:2019-09-28
 * @description:
 **/
@Configuration
public class RestTemplateUtils {
    @Value("${restTemplate.maxTotalConnect:50}")
    private Integer maxTotalConnect;
    @Value("${restTemplate.maxConnectPerRoute:100}")
    private Integer maxConnectPerRoute;
    @Value("${restTemplate.connectTimeout:3000}")
    private Integer connectTimeout;
    @Value("${restTemplate.readTimeout:5000}")
    private Integer readTimeout;

    @Value("${restTemplate.connectionRequestTimeout:3000}")
    private Integer connectionRequestTimeout;

    @Bean
    public ClientHttpRequestFactory clientHttpRequestFactory(){
        if(maxTotalConnect <= 0){
            SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
            factory.setConnectTimeout(connectTimeout);
            factory.setReadTimeout(readTimeout);
            return factory;
        }
        RequestConfig globalConfig = RequestConfig.custom().setCookieSpec(CookieSpecs.IGNORE_COOKIES).build();
        HttpClient httpClient = HttpClientBuilder.create().setMaxConnTotal(this.maxTotalConnect)
                .setMaxConnPerRoute(this.maxConnectPerRoute).setDefaultRequestConfig(globalConfig).build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory(httpClient);
        factory.setConnectTimeout(this.connectTimeout);
        factory.setReadTimeout(this.readTimeout);
        factory.setConnectionRequestTimeout(this.connectionRequestTimeout);
        return factory;
    }

    @Bean("comToolsRestTemolate")
    public RestTemplate restTemplate(@Qualifier("clientHttpRequestFactory") ClientHttpRequestFactory factory){
        return new RestTemplate(factory);
    }
}
