/**
 * Copyright (c) 2020, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.activity.center.api.dto.dpa;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 描述: 推广计划白名单
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2020/7/31 11:14
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PlanAdvertFeatureDTO implements Serializable {
    private static final long serialVersionUID = -404926332093324237L;

    /* 定制白名单开关 0-关 1-开 */
    private Integer directStatus;

    /* 仅投优投开关  1仅投放定制广告券列表，2优先投放定制广告券列表*/
    private Integer directModeStatus;

    /* 定制广告白名单 */
    private List<Long> advertIdWhiteList;

}
