package cn.com.duiba.tuia.activity.center.api.dto.tag;

import cn.com.duiba.tuia.activity.center.api.bean.enums.TagRelationTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 标签表
 *
 * @author YWG.MID.P
 * @email tangzhen@tuia.com.cn
 * @date 2020-07-24 11:46:45
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TagBindDTO implements Serializable {

    private Long subId;

    /**
     * 组件类 默认0，如：1-主标题，2-副标题
     */
    private Integer subType = 1;
    /**
     * 标签大类
     */
    private Long categoryId;

    /**
     * 所属标签组
     */
    private Long groupId;


    private List<Long> tagIds;

    /**
     * {@link TagRelationTypeEnum}
     */
    private Integer relationType;


    public TagBindDTO(Long subId, Integer relationType, List<Long> tagIds) {
        this.subId = subId;
        this.relationType = relationType;
        this.tagIds = tagIds;
    }
}
