package cn.com.duiba.tuia.activity.center.api.dto.programmatic;

import cn.com.duiba.tuia.activity.center.api.constant.FieldNameSpace;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;


/**
 * @author lizhiheng
 */
@Data
public class OriginalActivityDto implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 6403375826640016647L;

    /**
     * title:活动标题.
     */
    private String title;
    /**
     * activityType:活动type./刮刮卡之类
     */
    private Integer activityType;

    /**
     * limitCount:参与次数限制.
     */
    private Integer limitCount;
    /**
     * limitScope:限制类型(enum:LimitType).
     * 0 永久 1 每天
     * 先默认值1吧
     */
    private String limitScope = "1";
    /**
     * tag:标签.
     */
    private String tag;
    /**
     * isDeleted:是否删除.
     */
    private Boolean isDeleted;
    /**
     * isOpen:是否开启.
     */// 默认创建都时候关闭
    private Boolean isOpen;


//    private Boolean notice ;


    /**
     * 活动置顶
     * 是否置顶  0-非置顶  1-置顶
     */
    //                  我看数据库里都是0，应该是没有置顶，我默认设置0吧
    private Integer top = 0;

    /**
     * 0- 取消算法推荐，1- 加入算法推荐
     */
    //              我先默认0吧
    private Integer rcmd = 0;

    private Date rcmdGmtModified;
    /**
     * 0- 取消返回拦截算法推荐，1- 加入返回拦截算法推荐
     */
    // 我默认0吧
    private Integer intercept = 0;

    private Date interceptGmtModified;

    private Date gmtCreate;

    private Date gmtModified;


    /**
     * 活动预览链接
     * 裂变的海量活动不好截图，前端无法处理，先空着吧
     */
    private String previewUrl;

    /**
     * 是否支持增值
     * 这个参数说前端不想从活动里拿数据，应该是跟组件绑定，这里先设置不管吧，反正默认是false
     */
    private Boolean isEnc = Boolean.FALSE;


    /**
     * 是否是高中奖活动：0、不是 1、是
     * 活动本身是否是高中奖率，要便利所有奖项，如果有一个是，那活动就是高中奖率
     */
    private Integer isHighAwardRateActivity;

    /**
     * 审核状态
     */
    private Integer auditState;


    /**
     * 是否是程序化活动
     */
    private Boolean programmatic;

    /**
     * 判断 tag 字段与传过来的集合是否有交集
     *
     * @param coll tag集合
     * @return boolean
     */
    public boolean containTags(Collection<String> coll) {
        if (StringUtils.isBlank(tag) || coll == null || coll.isEmpty()) {
            return false;
        }

        String tags = new StringBuilder(FieldNameSpace.COMMA).append(tag).append(FieldNameSpace.COMMA).toString();

        for (String str : coll) {
            if (tags.contains(FieldNameSpace.COMMA + str + FieldNameSpace.COMMA)) {
                return true;
            }
        }

        return false;
    }
//    /**
//     * skinName:皮肤名称.
//     */
//    private String skinName;
//    /**
//     * activityTypeName:活动类型名称.
//     */
//    private String activityTypeName;              //这个应该可以删除，之前是用皮肤名称来确定activityType
//    /**
//     * subType:皮肤type.
//     */
//    private String subType;                        //这个应该可以删除，之前用subtype来查询是否开启增值，有个坑点，之前的增值叫ENC
//    /**
//     * 主标题id
//     */
//    private Long titleFirstId;                    // 这个没看懂干嘛的，好像是搜索的，数据库都是空的。先注释吧
//    /**
//     * 副标题id
//     */
//    private Long titleSecondId;                   // 这个没看懂干嘛的，好像是搜索的，数据库都是空的，先注释吧
//    /**
//     * 主标题名称
//     */
//    private String titleFirstName;      // 这个没看懂干嘛的，数据库都是空的，先注释吧
//    /**
//     * 副标题名称
//     */
//    private String titleSecondName;// 这个没看懂干嘛的，数据库都是空的，先注释吧

}
