package cn.com.duiba.tuia.activity.center.api.dto.programmatic;

import cn.com.duiba.tuia.activity.center.api.constant.risk.AuditState;
import lombok.Data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Data
public class ActivityListVo implements Serializable {
    private static final long serialVersionUID = -5662975134794817366L;
    private Long id;
    private Long originalActivityId;
    /**
     * 活动的名称
     */
    private String name;
    /**
     * 程序化活动名称
     */
    private String programmaticActivityName;
    /**
     * 奖品不足报警提醒通知人
     */
    private List<Long> ddNoticeId;
    /**
     * 活动策划人
     */
    private List<Long> planerId;
    /**
     * 1开启 0关闭
     */
    private Boolean isOpen;
    /**
     * 是否是高中奖率活动
     */
    private Integer isHighAwardRateActivity;
    /**
     * @see AuditState
     */
    private Integer auditState;
    /**
     * 审核消息
     */
    private String auditMsg;

    public static ActivityListVo convert(PageActivityRsp pageActivityRsp) {
        ActivityListVo activityListVo = new ActivityListVo();
        activityListVo.setId(pageActivityRsp.getId());
        activityListVo.setOriginalActivityId(pageActivityRsp.getOriginalActivityId());
        activityListVo.setName(pageActivityRsp.getName());
        activityListVo.setDdNoticeId(Arrays.stream(pageActivityRsp.getDdNoticeId().split(",")).map(Long::parseLong).collect(Collectors.toList()));
        activityListVo.setPlanerId(Arrays.stream(pageActivityRsp.getPlanerId().split(",")).map(Long::parseLong).collect(Collectors.toList()));
        activityListVo.setIsOpen(pageActivityRsp.getIsOpen());
        activityListVo.setIsHighAwardRateActivity(pageActivityRsp.getIsHighAwardRateActivity());
        activityListVo.setAuditState(pageActivityRsp.getAuditState());
        activityListVo.setAuditMsg(pageActivityRsp.getAuditMsg());
        activityListVo.setProgrammaticActivityName(pageActivityRsp.getProgrammaticActivityName());
        return activityListVo;
    }
}
