package cn.com.duiba.tuia.activity.center.api.dto.oceanengine;


import cn.com.duiba.tuia.activity.center.api.dto.OceanCreativeReportDTO;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;

/**
 * 创意报告返回参数
 *
 * @author duiba
 */
@NoArgsConstructor
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class OceanCreativeReportResponse {

    @JsonProperty("message")
    private String message;
    @JsonProperty("code")
    private Integer code;
    @JsonProperty("data")
    private DataDTO data;
    @JsonProperty("request_id")
    private String requestId;

    @NoArgsConstructor
    @Data
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class DataDTO {
        @JsonProperty("page_info")
        private PageInfoDTO pageInfo;
        @JsonProperty("list")
        private List<CreativeReport> list;

        @NoArgsConstructor
        @Data
        @JsonIgnoreProperties(ignoreUnknown = true)
        public static class PageInfoDTO {
            @JsonProperty("total_number")
            private Integer totalNumber;
            @JsonProperty("page")
            private Integer page;
            @JsonProperty("page_size")
            private Integer pageSize;
            @JsonProperty("total_page")
            private Integer totalPage;
        }

        @NoArgsConstructor
        @Data
        @JsonIgnoreProperties(ignoreUnknown = true)
        public static class CreativeReport {
            /**
             * 计划id，分组条件包含STAT_GROUP_BY_FIELD_ID时，返回具体值
             */
            @JsonProperty("ad_id")
            private String adId;
            /**
             * 创意id，分组条件包含STAT_GROUP_BY_FIELD_ID时，返回具体值
             */
            @JsonProperty("creative_id")
            private String creativeId;
            /**
             * 展现数据-展示数
             * 广告展示给用户的次数。计算方式：经平台判定有效且被计费的展示次数
             */
            @JsonProperty("show")
            private Integer show;
            /**
             * 展现数据-点击数
             * 当头条用户点击广告素材时，触发点击事件，该事件被认为是一次有效的广告点击
             */
            @JsonProperty("click")
            private Integer click;
            /**
             * 转化数据-转化数
             * 将转化数记录在转化事件发生的时间上。建议广告主考核成本时参考“转化数据（计费时间）”例如您的广告在早上8点进行了展示和点击，用户晚上19点发生了激活行为，我们会把激活数披露在晚上19点
             */
            @JsonProperty("convert")
            private Integer convert;
            /**
             * 展现数据-总花费
             * 表示广告在投放期内的预估花费金额,当天数据可能会有波动，次日稳定
             */
            @JsonProperty("cost")
            private BigDecimal cost;
            /**
             * 转化数据-转化成本
             * 广告主为每个转化所付出的平均成本，计算方式：总花费/转化数。当天数据可能会有波动
             */
            @JsonProperty("convert_cost")
            private BigDecimal convertCost;
            /**
             * 数据时间
             */
            @JsonProperty("stat_datetime")
            private String statDatetime;

//            @JsonProperty("next_day_open_rate")
//            private Integer nextDayOpenRate;
//            @JsonProperty("pre_loan_credit_cost")
//            private Integer preLoanCreditCost;
//            @JsonProperty("luban_live_gift_cnt")
//            private Integer lubanLiveGiftCnt;
//            @JsonProperty("follow")
//            private Integer follow;
//            @JsonProperty("valid_play_rate")
//            private Integer validPlayRate;
//            @JsonProperty("redirect")
//            private Integer redirect;
//            @JsonProperty("install_finish_cost")
//            private Integer installFinishCost;
//            @JsonProperty("valid_play")
//            private Integer validPlay;
//            @JsonProperty("wechat_login_count")
//            private Integer wechatLoginCount;
//            @JsonProperty("coupon")
//            private Integer coupon;
//            @JsonProperty("in_app_uv")
//            private Integer inAppUv;
//            @JsonProperty("pay_count")
//            private Integer payCount;
//            @JsonProperty("active_register_cost")
//            private Integer activeRegisterCost;
//            @JsonProperty("loan_credit")
//            private Integer loanCredit;
//            @JsonProperty("luban_live_enter_cnt")
//            private Integer lubanLiveEnterCnt;
//            @JsonProperty("click_website")
//            private Integer clickWebsite;
//            @JsonProperty("total_play")
//            private Integer totalPlay;
//            @JsonProperty("wechat_pay_amount")
//            private Integer wechatPayAmount;
//            @JsonProperty("attribution_wechat_first_pay_30d_count")
//            private Integer attributionWechatFirstPay30dCount;
//            @JsonProperty("loan_credit_rate")
//            private Integer loanCreditRate;
//            /**
//             * 计划名称，分组条件包含STAT_GROUP_BY_FIELD_ID时，返回具体值
//             */
//            @JsonProperty("ad_name")//
//            private Object adName;
//            @JsonProperty("luban_live_comment_cnt")
//            private Integer lubanLiveCommentCnt;
//            @JsonProperty("home_visited")
//            private Integer homeVisited;
//            @JsonProperty("luban_live_pay_order_count")
//            private Integer lubanLivePayOrderCount;
//            @JsonProperty("qq")
//            private Integer qq;
//            @JsonProperty("like")
//            private Integer like;
//            @JsonProperty("avg_show_cost")
//            private Integer avgShowCost;
//            @JsonProperty("button")
//            private Integer button;
//            @JsonProperty("loan_completion_cost")
//            private Integer loanCompletionCost;
//            @JsonProperty("in_app_cart")
//            private Integer inAppCart;
//            @JsonProperty("attribution_game_pay_7d_cost")
//            private Integer attributionGamePay7dCost;
//            @JsonProperty("attribution_wechat_login_30d_count")
//            private Integer attributionWechatLogin30dCount;
//            @JsonProperty("luban_order_roi")
//            private Integer lubanOrderRoi;
//            @JsonProperty("active_cost")
//            private Integer activeCost;
//            @JsonProperty("attribution_deep_convert_cost")
//            private Integer attributionDeepConvertCost;
//            @JsonProperty("attribution_deep_convert")
//            private Integer attributionDeepConvert;
//            @JsonProperty("next_day_open")
//            private Integer nextDayOpen;
//            @JsonProperty("install_finish")
//            private Integer installFinish;
//            @JsonProperty("download_finish_cost")
//            private Integer downloadFinishCost;

//            @JsonProperty("active_rate")
//            private Integer activeRate;
//            @JsonProperty("campaign_id")//
//            private Object campaignId;
//            @JsonProperty("advanced_creative_coupon_addition")
//            private Integer advancedCreativeCouponAddition;
//            @JsonProperty("active_pay_cost")
//            private Integer activePayCost;
//            @JsonProperty("poi_address_click")
//            private Integer poiAddressClick;

//            @JsonProperty("loan_completion")
//            private Integer loanCompletion;
//            @JsonProperty("luban_live_share_cnt")
//            private Integer lubanLiveShareCnt;
//            @JsonProperty("download")
//            private Integer download;
//            @JsonProperty("wechat_login_cost")
//            private Integer wechatLoginCost;

//            @JsonProperty("install_finish_rate")
//            private Integer installFinishRate;
//            @JsonProperty("attribution_wechat_first_pay_30d_cost")
//            private Integer attributionWechatFirstPay30dCost;
//            @JsonProperty("play_75_feed_break")
//            private Integer play75FeedBreak;
//            @JsonProperty("play_25_feed_break")
//            private Integer play25FeedBreak;

//            @JsonProperty("download_start_cost")
//            private Integer downloadStartCost;
//            @JsonProperty("redirect_to_shop")
//            private Integer redirectToShop;
//            @JsonProperty("wechat_first_pay_count")
//            private Integer wechatFirstPayCount;
//            @JsonProperty("luban_live_gift_amount")
//            private Integer lubanLiveGiftAmount;
//            @JsonProperty("play_duration_sum")
//            private Integer playDurationSum;
//            @JsonProperty("attribution_next_day_open_cost")
//            private Integer attributionNextDayOpenCost;
//            @JsonProperty("play_over_rate")
//            private Integer playOverRate;
//            @JsonProperty("play_50_feed_break")
//            private Integer play50FeedBreak;

//            @JsonProperty("click_call_dy")
//            private Integer clickCallDy;
//            @JsonProperty("ies_challenge_click")
//            private Integer iesChallengeClick;
//            @JsonProperty("active")
//            private Integer active;
//            @JsonProperty("lottery")
//            private Integer lottery;
//            @JsonProperty("loan_completion_rate")
//            private Integer loanCompletionRate;
//            @JsonProperty("wifi_play")
//            private Integer wifiPlay;

//            @JsonProperty("ctr")
//            private Integer ctr;
//            @JsonProperty("avg_click_cost")
//            private Integer avgClickCost;
//            @JsonProperty("game_pay_cost")
//            private Integer gamePayCost;
//            /**
//             * 转化数据-深度转化成本
//             * 广告主为每个深度转化所付出的平均成本，计算方法：总花费/深度转化数。当天数据可能会有波动，次日早8点后稳定
//             */
//            @JsonProperty("deep_convert_cost")
//            private Integer deepConvertCost;
//            @JsonProperty("attribution_wechat_pay_30d_roi")
//            private Integer attributionWechatPay30dRoi;
//            @JsonProperty("wechat")
//            private Integer wechat;
//            @JsonProperty("view")
//            private Integer view;
//            @JsonProperty("attribution_convert_cost")
//            private Integer attributionConvertCost;
//            @JsonProperty("consult_effective")
//            private Integer consultEffective;
//            @JsonProperty("comment")
//            private Integer comment;
//            @JsonProperty("luban_live_click_product_cnt")
//            private Integer lubanLiveClickProductCnt;
//            @JsonProperty("convert_rate")
//            private Integer convertRate;
//            @JsonProperty("active_register_rate")
//            private Integer activeRegisterRate;
//            @JsonProperty("click_landing_page")
//            private Integer clickLandingPage;
//            @JsonProperty("game_addiction")
//            private Integer gameAddiction;
//            @JsonProperty("message_action")
//            private Integer messageAction;
//            @JsonProperty("campaign_name")//
//            private Object campaignName;
//            @JsonProperty("message")
//            private Integer message;
//            @JsonProperty("poi_collect")
//            private Integer poiCollect;
//            @JsonProperty("attribution_next_day_open_cnt")
//            private Integer attributionNextDayOpenCnt;
//            @JsonProperty("attribution_active_pay_7d_per_count")
//            private Integer attributionActivePay7dPerCount;
//            @JsonProperty("vote")
//            private Integer vote;
//            @JsonProperty("luban_live_pay_order_stat_cost")
//            private Integer lubanLivePayOrderStatCost;
//            @JsonProperty("download_finish_rate")
//            private Integer downloadFinishRate;
//            @JsonProperty("loan_credit_cost")
//            private Integer loanCreditCost;
//            @JsonProperty("deep_convert_rate")
//            private Integer deepConvertRate;
//            @JsonProperty("game_addiction_cost")
//            private Integer gameAddictionCost;
//            @JsonProperty("shopping")
//            private Integer shopping;
//            @JsonProperty("luban_order_cnt")
//            private Integer lubanOrderCnt;
//            @JsonProperty("advanced_creative_phone_click")
//            private Integer advancedCreativePhoneClick;
//            @JsonProperty("luban_live_slidecart_click_cnt")
//            private Integer lubanLiveSlidecartClickCnt;
//            @JsonProperty("phone")
//            private Integer phone;
//            @JsonProperty("wifi_play_rate")
//            private Integer wifiPlayRate;
//            @JsonProperty("consult")
//            private Integer consult;
//            @JsonProperty("wechat_first_pay_cost")
//            private Integer wechatFirstPayCost;
//            @JsonProperty("game_addiction_rate")
//            private Integer gameAddictionRate;
//            @JsonProperty("active_pay_rate")
//            private Integer activePayRate;
//            @JsonProperty("download_start")
//            private Integer downloadStart;
//            @JsonProperty("card_show")
//            private Integer cardShow;
//            @JsonProperty("map_search")
//            private Integer mapSearch;
//            @JsonProperty("in_app_order")
//            private Integer inAppOrder;
//            @JsonProperty("attribution_convert")
//            private Integer attributionConvert;
//            @JsonProperty("wechat_first_pay_rate")
//            private Integer wechatFirstPayRate;
//            @JsonProperty("attribution_game_pay_7d_count")
//            private Integer attributionGamePay7dCount;
//            @JsonProperty("click_download")
//            private Integer clickDownload;
//            @JsonProperty("pre_loan_credit")
//            private Integer preLoanCredit;
//            @JsonProperty("attribution_wechat_login_30d_cost")
//            private Integer attributionWechatLogin30dCost;
//            @JsonProperty("share")
//            private Integer share;
//            @JsonProperty("click_install")
//            private Integer clickInstall;
//            @JsonProperty("advanced_creative_form_submit")
//            private Integer advancedCreativeFormSubmit;
//            @JsonProperty("deep_convert")
//            private Integer deepConvert;
//            @JsonProperty("live_fans_club_join_cnt")
//            private Integer liveFansClubJoinCnt;
//            @JsonProperty("phone_connect")
//            private Integer phoneConnect;
//            @JsonProperty("id")
//            private Object id;
//            @JsonProperty("ies_music_click")
//            private Integer iesMusicClick;
//            @JsonProperty("play_100_feed_break")
//            private Integer play100FeedBreak;
//            @JsonProperty("coupon_single_page")
//            private Integer couponSinglePage;
//            @JsonProperty("form")
//            private Integer form;
//            @JsonProperty("valid_play_cost")
//            private Integer validPlayCost;
//            @JsonProperty("live_watch_one_minute_count")
//            private Integer liveWatchOneMinuteCount;
//            @JsonProperty("luban_order_stat_amount")
//            private Integer lubanOrderStatAmount;
//            @JsonProperty("download_start_rate")
//            private Integer downloadStartRate;
//            @JsonProperty("attribution_next_day_open_rate")
//            private Integer attributionNextDayOpenRate;
//            @JsonProperty("download_finish")
//            private Integer downloadFinish;
//            @JsonProperty("inventory")
//            private Object inventory;
//            @JsonProperty("attribution_wechat_first_pay_30d_rate")
//            private Integer attributionWechatFirstPay30dRate;
//            @JsonProperty("attribution_wechat_pay_30d_amount")
//            private Integer attributionWechatPay30dAmount;
//            @JsonProperty("advanced_creative_counsel_click")
//            private Integer advancedCreativeCounselClick;
//            @JsonProperty("phone_effective")
//            private Integer phoneEffective;
//            @JsonProperty("in_app_detail_uv")
//            private Integer inAppDetailUv;
//            @JsonProperty("average_play_time_per_play")
//            private Integer averagePlayTimePerPlay;
//            @JsonProperty("phone_confirm")
//            private Integer phoneConfirm;
//            @JsonProperty("location_click")
//            private Integer locationClick;
//            @JsonProperty("game_pay_count")
//            private Integer gamePayCount;
//            @JsonProperty("click_shopwindow")
//            private Integer clickShopwindow;
//            @JsonProperty("register")
//            private Integer register;
//            @JsonProperty("in_app_pay")
//            private Integer inAppPay;
//            @JsonProperty("luban_live_follow_cnt")
//            private Integer lubanLiveFollowCnt;
//            @JsonProperty("next_day_open_cost")
//            private Integer nextDayOpenCost;
//            @JsonProperty("advanced_creative_form_click")
//            private Integer advancedCreativeFormClick;
        }
    }
}
