package cn.com.duiba.tuia.activity.center.api.dto;

import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 腾讯活动送审记录对象 tb_tencent_activity_audit_record
 * 
 * @author YanfeiAndAHai
 * @date 2023-02-22
 */
@Data
public class TencentActivityAuditRecordDTO {
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 创建时间 */
    private Date gmtCreate;

    /** 修改时间 */
    private Date gmtModified;

    /** 送审记录表id */
    private Long submissionId;

    /** 媒体账户id */
    private Long accountId;

    /** 落地页id */
    private Long landId;

    /** 活动id */
    private Long activityId;

    /** 媒体id */
    private Long appId;

    private List<Long> appIds;

    /**
     * 广告位id
     */
    private Long slotId;

    /**
     * 最近送审时间
     */
    private Date lastAuditTime;

    /**
     * 1-已送审 2-送审失败
     */
    private Integer auditStatus;

    /**
     * 送审记录归属人
     */
    private String adminName;
    /**
     * 送审记录归属人ID
     */
    private Long adminId;

    /**
     * 最后送审人
     */
    private String lastAuditAdminName;

    /**
     * 最后送审人Id
     */
    private Long lastAuditAdminId;

    private Integer rowStart;

    private Integer pageSize;

}
