package cn.com.duiba.tuia.activity.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhiheng
 */
@Data
public class ProgrammaticFissionActivityDto implements Serializable {

    /**
     * 主键
     */
    private Long id;

    /**
     * tb_tuia_activity表里的活动id，因为暂时还需要那张表进行数据存储,到时候下线旧表就可以删除这个字段了
     */
    private Long originalActivityId;

    /**
     * 是否删除
     */
    private Boolean isDelete;

    /**
     * 创建人id
     */
    private String adminId;

    /**
     * 壳子id
     */
    private Long templateId;

    /**
     * 最新编辑人id
     */
    private String latestAdminId;

    /**
     * 模版id
     */
    private Long modelId;

    /**
     * 奖品不足报警提醒通知人
     */
    private String ddNoticeId;

    /**
     * 奖品不足报警提醒通知人电话
     */
    private String ddNoticePhone;

    /**
     * 活动策划人
     */
    private String planerId;

    /**
     * 程序化活动id
     */
    private Long programmaticActivityId;

    /**
     * 程序化活动名称
     */
    private String name;

    /**
     * 程序化活动描述
     */
    private String description;


    /**
     * 页面上的代码捆绑包, 即组件、core、插件等链接的合并内容
     */
    private Object runtimeBundle;

    /**
     * 页面访问时的组件配置
     */
    private Object runtimeAssets;
    /**
     * 页面上链路配置生成的方法
     */
    private Object runtimeDynamicChain;
    /**
     * 页面上依赖的组件名称
     */
    private Object runtimeComponents;
    /**
     * 页面搭建时的组件配置
     */
    private Object compilerAssets;
    /**
     * 页面上用到了哪些依赖
     */
    private Object compilerPresets;

    /**
     * 包含的组件实例
     */
    private String includedInstance;

    /**
     * status,记录活动现在的状态，
     * 1.初始化生成状态，这个时候的runtmeXXX相关参数都可能是空的
     * 2.活动被选择生成
     */
    private Integer status;

    /**
     * 活动静态页地址
     */
    private String staticPage;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
