package cn.com.duiba.tuia.activity.center.api.constant;

import lombok.Getter;

import java.util.Calendar;

/**
 * 分时段库存的时段枚举
 * @author miaohongshuai
 * @date 2021-04-27
*/
@Getter
public enum HourLimitStockHourIntervalEnum {
    ZERO_TO_ONE("0-1", "0到1小时之间"),
    ONE_TO_TWO("1-2", "1到2小时之间"),
    THIRTEEN_TO_FOURTEEN("13-14", "13到14小时之间"),
    ;

    /** 小时段 */
    private String hourInterval;
    /** 小时段描述 */
    private String desc;

    HourLimitStockHourIntervalEnum(String hourInterval, String desc) {
        this.hourInterval = hourInterval;
        this.desc = desc;
    }

    public static String getHourInterval(Calendar ca) {
        int hourOfDay = ca.get(Calendar.HOUR_OF_DAY);
        String hourInterval = hourOfDay + "-" + (hourOfDay + 1);
        System.out.println(hourInterval);
        return hourInterval;
    }
}
