package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.AppletPaymentResultDTO;

/**
 * @Author yuquanfeng
 * @Date 2022/11/28
 * @Description
 * @Param
 * @return
 **/
@AdvancedFeignClient
public interface RemoteAppletPaymentResultService {
    /**
     * 添加付款结果记录
     * @param appletPaymentResultDTO
     * @return
     */
    Boolean addAppletPaymentResult(AppletPaymentResultDTO appletPaymentResultDTO);

    /**
     * 付款是否成功
     * @param orderId 订单id
     * @return
     */
    Boolean paymentIsSuccess(Long orderId);

    /**
     * 通过订单号查询
     * @param orderId
     * @return
     */
    AppletPaymentResultDTO queryOrderByOrderId(Long orderId);

    /**
     * 通过id更新订单信息
     * @return
     */
    Boolean updateOrderById(AppletPaymentResultDTO appletPaymentResultDTO);
}
